/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.download.vector.read_from_geofabrik;

import ch.res_ear.samthiriot.knime.download.vector.read_from_geofabrik.GeofabrikUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnProperties;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.MissingCell;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReadWKTFromGeofabrikNodeModel
extends NodeModel {
    private SettingsModelString m_nameToLoad = new SettingsModelString("name_to_load", "Europe/Germany/Baden-W\u00fcrttemberg/Regierungsbezirk Karlsruhe");
    private SettingsModelString m_layerToLoad = new SettingsModelString("layer_to_load", "buildings (Building outlines)");
    private MissingCell missing = new MissingCell("not provided");

    protected ReadWKTFromGeofabrikNodeModel() {
        super(0, 1);
    }

    private DataColumnSpec[] createSpecs() {
        LinkedList<DataColumnSpec> specs = new LinkedList<DataColumnSpec>();
        specs.add(new DataColumnSpecCreator("id", StringCell.TYPE).createSpec());
        DataColumnSpecCreator creator = new DataColumnSpecCreator("the_geom", StringCell.TYPE);
        HashMap<String, String> properties = new HashMap<String, String>();
        CoordinateReferenceSystem coordinateReferenceSystem = SpatialUtils.getCRSforString((String)"EPSG:4326");
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)coordinateReferenceSystem));
        properties.put("crs WKT", coordinateReferenceSystem.toWKT());
        DataColumnProperties propertiesKWT = new DataColumnProperties(properties);
        creator.setProperties(propertiesKWT);
        specs.add(creator.createSpec());
        specs.add(new DataColumnSpecCreator("osm_id", StringCell.TYPE).createSpec());
        specs.add(new DataColumnSpecCreator("code", IntCell.TYPE).createSpec());
        specs.add(new DataColumnSpecCreator("fclass", StringCell.TYPE).createSpec());
        specs.add(new DataColumnSpecCreator("name", StringCell.TYPE).createSpec());
        if (this.m_layerToLoad.getStringValue().startsWith("places")) {
            specs.add(new DataColumnSpecCreator("population", IntCell.TYPE).createSpec());
        } else if (this.m_layerToLoad.getStringValue().startsWith("roads")) {
            specs.add(new DataColumnSpecCreator("ref", StringCell.TYPE).createSpec());
            specs.add(new DataColumnSpecCreator("oneway", StringCell.TYPE).createSpec());
            specs.add(new DataColumnSpecCreator("maxspeed", IntCell.TYPE).createSpec());
            specs.add(new DataColumnSpecCreator("layer", IntCell.TYPE).createSpec());
            specs.add(new DataColumnSpecCreator("bridge", BooleanCell.TYPE).createSpec());
            specs.add(new DataColumnSpecCreator("tunnel", BooleanCell.TYPE).createSpec());
        } else if (this.m_layerToLoad.getStringValue().startsWith("railways")) {
            specs.add(new DataColumnSpecCreator("layer", IntCell.TYPE).createSpec());
            specs.add(new DataColumnSpecCreator("bridge", BooleanCell.TYPE).createSpec());
            specs.add(new DataColumnSpecCreator("tunnel", BooleanCell.TYPE).createSpec());
        } else if (this.m_layerToLoad.getStringValue().startsWith("waterways")) {
            specs.add(new DataColumnSpecCreator("width", IntCell.TYPE).createSpec());
        } else if (this.m_layerToLoad.getStringValue().startsWith("buildings")) {
            specs.add(new DataColumnSpecCreator("type", StringCell.TYPE).createSpec());
        }
        return specs.toArray(new DataColumnSpec[specs.size()]);
    }

    protected DataCell getStringOrMissing(Object stringValue) {
        if (stringValue == null) {
            return this.missing;
        }
        String str = stringValue.toString();
        if (str.isEmpty()) {
            return this.missing;
        }
        return StringCell.StringCellFactory.create((String)str);
    }

    protected DataCell getIntOrMissing(Object intValue) {
        if (intValue == null) {
            return this.missing;
        }
        return IntCell.IntCellFactory.create((String)intValue.toString());
    }

    protected DataCell getIntOrMissingIfZero(Object intValue) {
        if (intValue == null) {
            return this.missing;
        }
        String str = intValue.toString();
        if (str.equals("0")) {
            return this.missing;
        }
        return IntCell.IntCellFactory.create((String)str);
    }

    protected DataCell getBoolOrMissing(Object val) {
        if (val == null) {
            return this.missing;
        }
        String str = val.toString();
        if (str.equals("T")) {
            return BooleanCell.BooleanCellFactory.create((boolean)true);
        }
        if (str.equals("F")) {
            return BooleanCell.BooleanCellFactory.create((boolean)false);
        }
        return this.missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        String paramLayerToRead;
        String nameToDownload = this.m_nameToLoad.getStringValue();
        exec.checkCanceled();
        exec.setMessage("finding URL...");
        String urlToDownload = GeofabrikUtils.fetchListOfDataExtracts().get(nameToDownload);
        URL urlToDownload2 = new URL(urlToDownload);
        exec.checkCanceled();
        exec.setMessage("estimating size");
        int total = Integer.parseInt(urlToDownload2.openConnection().getHeaderField("Content-Length"));
        exec.checkCanceled();
        exec.setMessage("downloading (" + total / 1024 / 1024 + " Mb)");
        File destFile = null;
        ExecutionContext execCopy = exec.createSubExecutionContext(0.6);
        File dirShapefiles = new File(GeofabrikUtils.getFileForCache(), "shapefiles");
        dirShapefiles.mkdirs();
        destFile = new File(dirShapefiles, String.valueOf(nameToDownload.replaceAll("/", "_")) + ".shp.zip");
        Object object = GeofabrikUtils.getLockForFile(destFile.getAbsolutePath());
        synchronized (object) {
            if (!destFile.exists()) {
                FileOutputStream os = new FileOutputStream(destFile);
                DownloadCountingOutputStream cos = new DownloadCountingOutputStream(os, execCopy, total);
                URLConnection connection = urlToDownload2.openConnection();
                connection.setUseCaches(true);
                IOUtils.copy((InputStream)connection.getInputStream(), (OutputStream)((Object)cos));
                cos.close();
            }
        }
        exec.checkCanceled();
        exec.setProgress(0.6, "unzipping");
        File destDir = Files.createTempDirectory("geofabrik", new FileAttribute[0]).toFile();
        File fileForShp = null;
        String layerCode = paramLayerToRead = this.m_layerToLoad.getStringValue();
        int idxSpace = layerCode.indexOf(" ");
        if (idxSpace > 0) {
            layerCode = layerCode.substring(0, idxSpace);
        }
        String layerCodeToSearch = layerCode;
        try (ZipFile zipFile = null;){
            try {
                zipFile = new ZipFile(destFile);
                Collection relevantEntries = zipFile.stream().filter(entry -> entry.getName().contains(layerCodeToSearch)).collect(Collectors.toList());
                for (ZipEntry zipEntry : relevantEntries) {
                    exec.setMessage("unzipping " + zipEntry.getName());
                    InputStream is = zipFile.getInputStream(zipEntry);
                    File destFileEntry = new File(destDir, zipEntry.getName());
                    FileOutputStream os = new FileOutputStream(destFileEntry);
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                    if (!zipEntry.getName().endsWith(".shp")) continue;
                    fileForShp = destFileEntry;
                }
            }
            catch (ZipException zipException) {
                destFile.delete();
                throw new RuntimeException("error when opening downloaded data. Please try to reexecute...");
            }
        }
        if (fileForShp == null) {
            throw new RuntimeException("no shp file found for layer " + paramLayerToRead + " for country " + nameToDownload);
        }
        exec.checkCanceled();
        exec.setProgress(0.6, "loading");
        DataStore datastore = null;
        HashMap<String, URL> parameters = new HashMap<String, URL>();
        try {
            parameters.put("url", fileForShp.toURI().toURL());
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException("cannot convert the path " + fileForShp + " to an URL", e2);
        }
        try {
            this.getLogger().info((Object)("opening as a shapefile: " + fileForShp));
            datastore = DataStoreFinder.getDataStore(parameters);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new InvalidSettingsException("Unable to open the url as a shape file: " + e1.getMessage());
        }
        if (datastore == null) {
            throw new InvalidSettingsException("unable to open the shapefile from path " + fileForShp);
        }
        try {
            ((ShapefileDataStore)datastore).setCharset(StandardCharsets.UTF_8);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidSettingsException("unable to define charset for this datastore");
        }
        String schemaName = datastore.getTypeNames()[0];
        DataColumnSpec[] colSpecs = this.createSpecs();
        DataTableSpec outputSpec = new DataTableSpec(colSpecs);
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        int totalFeatures = datastore.getFeatureSource(schemaName).getFeatures().size();
        ExecutionContext execCreate = exec.createSubExecutionContext(0.4);
        SimpleFeatureIterator itFeature = datastore.getFeatureSource(schemaName).getFeatures().features();
        int rowIdx = 0;
        while (itFeature.hasNext()) {
            SimpleFeature feature = (SimpleFeature)itFeature.next();
            int i = 0;
            DataCell[] cells = new DataCell[colSpecs.length];
            cells[i++] = StringCell.StringCellFactory.create((String)feature.getID());
            cells[i++] = StringCell.StringCellFactory.create((String)feature.getAttribute("the_geom").toString());
            cells[i++] = StringCell.StringCellFactory.create((String)feature.getAttribute("osm_id").toString());
            cells[i++] = IntCell.IntCellFactory.create((String)feature.getAttribute("code").toString());
            cells[i++] = this.getStringOrMissing(feature.getAttribute("fclass"));
            cells[i++] = this.getStringOrMissing(feature.getAttribute("name"));
            if (paramLayerToRead.startsWith("places")) {
                cells[i++] = this.getIntOrMissing(feature.getAttribute("population"));
            } else if (paramLayerToRead.startsWith("roads")) {
                cells[i++] = this.getStringOrMissing(feature.getAttribute("ref"));
                cells[i++] = this.getStringOrMissing(feature.getAttribute("oneway").toString());
                cells[i++] = this.getIntOrMissingIfZero(feature.getAttribute("maxspeed"));
                cells[i++] = IntCell.IntCellFactory.create((String)feature.getAttribute("layer").toString());
                cells[i++] = this.getBoolOrMissing(feature.getAttribute("bridge"));
                cells[i++] = this.getBoolOrMissing(feature.getAttribute("tunnel"));
            } else if (this.m_layerToLoad.getStringValue().startsWith("railways")) {
                cells[i++] = IntCell.IntCellFactory.create((String)feature.getAttribute("layer").toString());
                cells[i++] = this.getBoolOrMissing(feature.getAttribute("bridge").toString());
                cells[i++] = this.getBoolOrMissing(feature.getAttribute("tunnel").toString());
            } else if (this.m_layerToLoad.getStringValue().startsWith("waterways")) {
                cells[i++] = this.getIntOrMissingIfZero(feature.getAttribute("width"));
            } else if (this.m_layerToLoad.getStringValue().startsWith("buildings")) {
                cells[i++] = this.getStringOrMissing(feature.getAttribute("type"));
            }
            container.addRowToTable((DataRow)new DefaultRow(new RowKey("Row " + rowIdx), cells));
            if (rowIdx % 10 == 0) {
                exec.checkCanceled();
                execCreate.setProgress((double)rowIdx / (double)totalFeatures, "reading row " + rowIdx);
            }
            ++rowIdx;
        }
        itFeature.close();
        datastore.dispose();
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[]{new DataTableSpec(this.createSpecs())};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_nameToLoad.saveSettingsTo(settings);
        this.m_layerToLoad.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_nameToLoad.loadSettingsFrom(settings);
        this.m_layerToLoad.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_nameToLoad.validateSettings(settings);
        this.m_layerToLoad.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }

    public static class DownloadCountingOutputStream
    extends CountingOutputStream {
        private final ExecutionContext exec;
        private final double total;
        private double done = 0.0;

        public DownloadCountingOutputStream(OutputStream out, ExecutionContext exec, int total) {
            super(out);
            this.exec = exec;
            this.total = total;
        }

        protected void afterWrite(int n) throws IOException {
            super.afterWrite(n);
            try {
                this.exec.checkCanceled();
            }
            catch (CanceledExecutionException canceledExecutionException) {
                throw new RuntimeException("execution canceled");
            }
            this.done += (double)n;
            this.exec.setProgress(this.done / this.total);
        }
    }
}

