/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.multilevel.spatial.composer;

import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelPopulationPortObject;
import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelPopulationPortSpec;
import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelUtils;
import ch.res_ear.samthiriot.knime.gosp.multilevel.spatial.composer.SpatialComposerUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.map.LRUMap;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ComposeBySpatialProximityFromMultilevelNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(ComposeBySpatialProximityFromMultilevelNodeModel.class);
    public static final String MODEL_KEY_LINKTYPE_INSIDE = "link_type_inside";
    public static final String MODEL_KEY_LINKTYPE_PROXIMITY = "link_type_proximity";
    public static final String MODEL_KEY_PARENT = "parent_type_name";
    public static final String MODEL_KEY_CHILDREN = "children_type_name";
    public static final String MODEL_KEY_DISTANCE = "max_distance";
    private final SettingsModelString m_linkTypeInside = new SettingsModelString("link_type_inside", "inside");
    private final SettingsModelString m_linkTypeProximity = new SettingsModelString("link_type_proximity", "close to");
    private final SettingsModelString m_parentName = new SettingsModelString("parent_type_name", "parent");
    private final SettingsModelString m_childName = new SettingsModelString("children_type_name", "child");
    private final SettingsModelIntegerBounded m_distance = new SettingsModelIntegerBounded("max_distance", 10, 0, 100);

    protected ComposeBySpatialProximityFromMultilevelNodeModel() {
        super(new PortType[]{MultilevelPopulationPortObject.TYPE}, new PortType[]{MultilevelPopulationPortObject.TYPE});
    }

    protected MultilevelPopulationPortSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        MultilevelPopulationPortSpec specsOrig = (MultilevelPopulationPortSpec)inSpecs[0];
        MultilevelPopulationPortSpec specsRes = new MultilevelPopulationPortSpec(specsOrig);
        specsRes.addLinkType(this.m_linkTypeInside.getStringValue());
        specsRes.addLinkType(this.m_linkTypeProximity.getStringValue());
        return new MultilevelPopulationPortSpec[]{specsRes};
    }

    protected MultilevelPopulationPortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        ExecutionMonitor execProgressDecodeParents = exec.createSubProgress(0.1);
        ExecutionMonitor execProgressDecodeChildren = exec.createSubProgress(0.1);
        ExecutionMonitor execProgressSpatialParents = exec.createSubProgress(0.1);
        ExecutionMonitor execProgressSpatialChildren = exec.createSubProgress(0.1);
        ExecutionMonitor execProgressMatchingOne = exec.createSubProgress(0.3);
        ExecutionMonitor execProgressMatchingTwo = exec.createSubProgress(0.3);
        String parentName = this.m_parentName.getStringValue();
        String childName = this.m_childName.getStringValue();
        String linkNameInside = this.m_linkTypeInside.getStringValue();
        String linkNameProximity = this.m_linkTypeProximity.getStringValue();
        Integer maxDistance = this.m_distance.getIntValue();
        MultilevelPopulationPortObject multilevelOrig = (MultilevelPopulationPortObject)inObjects[0];
        MultilevelPopulationPortObject multilevelRes = new MultilevelPopulationPortObject(multilevelOrig, exec);
        if (!SpatialUtils.hasGeometry((DataTableSpec)multilevelRes.getTableForEntityType(parentName).getDataTableSpec())) {
            throw new IllegalArgumentException("the input table for parents contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)multilevelRes.getTableForEntityType(parentName).getDataTableSpec())) {
            throw new IllegalArgumentException("the input table for parents contains spatial data but no Coordinate Reference System");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)multilevelRes.getTableForEntityType(childName).getDataTableSpec())) {
            throw new IllegalArgumentException("the input table for children contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)multilevelRes.getTableForEntityType(childName).getDataTableSpec())) {
            throw new IllegalArgumentException("the input table for children contains spatial data but no Coordinate Reference System");
        }
        exec.setProgress("Retrieving " + parentName);
        BufferedDataTable sampleParents = MultilevelUtils.getAsBufferedDataTable((DataTable)multilevelRes.getTableForEntityType(parentName), (ExecutionContext)exec, (ExecutionMonitor)execProgressDecodeParents);
        exec.setProgress("Retrieving " + childName);
        BufferedDataTable sampleChildren = MultilevelUtils.getAsBufferedDataTable((DataTable)multilevelRes.getTableForEntityType(childName), (ExecutionContext)exec, (ExecutionMonitor)execProgressDecodeChildren);
        exec.setProgress("Cloning " + parentName);
        CoordinateReferenceSystem csrParents = SpatialUtils.decodeCRS((DataTableSpec)sampleParents.getDataTableSpec());
        CoordinateReferenceSystem csrChildren = SpatialUtils.decodeCRS((DataTableSpec)sampleChildren.getDataTableSpec());
        if (!csrParents.getCoordinateSystem().equals(csrChildren.getCoordinateSystem())) {
            throw new IllegalArgumentException("The Coordinate Reference Systems of parents and children should be the same.");
        }
        CoordinateReferenceSystem crs = csrParents;
        BufferedDataContainer containerLinks = exec.createDataContainer(MultilevelUtils.getSpecsForLinksTable());
        DataStore datastoreParents = SpatialUtils.createDataStore();
        DataStore datastoreChildren = SpatialUtils.createDataStore();
        String featureParent = "parents";
        String featureChildren = "children";
        exec.setProgress("Spatializing parents & children");
        Runnable runnableSpatializeParents = SpatialUtils.decodeAsFeaturesRunnable((BufferedDataTable)sampleParents, (String)"the_geom", (ExecutionMonitor)execProgressSpatialParents, (DataStore)datastoreParents, (String)"parents", (CoordinateReferenceSystem)crs, (boolean)true, null);
        Runnable runnableSpatializeChildren = SpatialUtils.decodeAsFeaturesRunnable((BufferedDataTable)sampleChildren, (String)"the_geom", (ExecutionMonitor)execProgressSpatialChildren, (DataStore)datastoreChildren, (String)"children", (CoordinateReferenceSystem)crs, (boolean)true, null);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(runnableSpatializeParents);
        executor.execute(runnableSpatializeChildren);
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        long totalParents = sampleParents.size();
        long totalChildren = sampleChildren.size();
        exec.setProgress("Matching children inside parents");
        BufferedDataTable previousTableLinks = exec.createBufferedDataTable(multilevelRes.getTableLinks(), exec.createSilentSubProgress(0.0));
        long previousLinksCount = previousTableLinks.size();
        HashSet<Integer> childWithParent = new HashSet<Integer>();
        DataCell cellLinkTypeInside = StringCell.StringCellFactory.create((String)linkNameInside);
        DataCell cellLinkTypeProximity = StringCell.StringCellFactory.create((String)linkNameProximity);
        DataCell cellEntityTypeParent = StringCell.StringCellFactory.create((String)parentName);
        DataCell cellEntityTypeChild = StringCell.StringCellFactory.create((String)childName);
        multilevelRes.declareLinkType(linkNameInside);
        SimpleFeatureIterator itParents = datastoreParents.getFeatureSource((Name)datastoreParents.getNames().get(0)).getFeatures().features();
        int idxAttributeIdParent = ((SimpleFeatureType)datastoreParents.getFeatureSource((Name)datastoreParents.getNames().get(0)).getSchema()).indexOf("inc_id");
        int idxAttributeGeomParent = ((SimpleFeatureType)datastoreParents.getFeatureSource((Name)datastoreParents.getNames().get(0)).getSchema()).indexOf("the_geom");
        int idxAttributeIdChild = ((SimpleFeatureType)datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)).getSchema()).indexOf("inc_id");
        int idxAttributeGeomChild = ((SimpleFeatureType)datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)).getSchema()).indexOf("the_geom");
        long currentParentIdx = 0L;
        while (itParents.hasNext()) {
            SimpleFeature parentFeature = (SimpleFeature)itParents.next();
            Integer idParent = (Integer)parentFeature.getAttribute(idxAttributeIdParent);
            FeatureIterator itChildsComposed = SpatialUtils.findEntitiesWithin((SimpleFeatureSource)datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)), (Geometry)((Geometry)parentFeature.getAttribute(idxAttributeGeomParent)));
            while (itChildsComposed.hasNext()) {
                SimpleFeature child = (SimpleFeature)itChildsComposed.next();
                Integer idChild = (Integer)child.getAttribute(idxAttributeIdChild);
                if (childWithParent.contains(idChild)) continue;
                childWithParent.add(idChild);
                containerLinks.addRowToTable(MultilevelUtils.getRowForLink((String)("Link " + (previousLinksCount + containerLinks.size())), (DataCell)cellLinkTypeInside, (Integer)idChild, (DataCell)cellEntityTypeChild, (Integer)idParent, (DataCell)cellEntityTypeParent));
            }
            itChildsComposed.close();
            if (currentParentIdx % 10L == 0L) {
                execProgressMatchingOne.setProgress((double)currentParentIdx / (double)totalParents, "searching inside " + parentName + " " + currentParentIdx);
                execProgressMatchingOne.checkCanceled();
            }
            ++currentParentIdx;
        }
        itParents.close();
        execProgressMatchingOne.setProgress(1.0);
        long orphanChildren = totalChildren - (long)childWithParent.size();
        this.getLogger().info((Object)("During the first step, found " + childWithParent.size() + "/" + totalChildren + "; remain " + orphanChildren + " orphans"));
        ArrayList<Integer> orphanIds = new ArrayList<Integer>();
        if (maxDistance > 0 && orphanChildren > 0L) {
            multilevelRes.declareLinkType(linkNameProximity);
            long currentChildIdx = 0L;
            SimpleFeatureIterator itChild = datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)).getFeatures().features();
            LRUMap childGrom2closestGeom = new LRUMap(1000);
            while (itChild.hasNext()) {
                SimpleFeature childFeature = (SimpleFeature)itChild.next();
                Geometry childGeom = (Geometry)childFeature.getAttribute(idxAttributeGeomChild);
                Integer idChild = (Integer)childFeature.getAttribute(idxAttributeIdChild);
                if (currentChildIdx % 10L == 0L) {
                    execProgressMatchingTwo.setProgress((double)currentChildIdx / (double)totalChildren, "searching for " + parentName + " around " + childName + " " + currentChildIdx);
                    execProgressMatchingTwo.checkCanceled();
                }
                ++currentChildIdx;
                if (childWithParent.contains(idChild)) continue;
                System.out.println("who is close to " + idChild + " " + childFeature.getAttribute(0));
                SimpleFeature parentFeature = null;
                if (childGrom2closestGeom.containsKey((Object)childGeom)) {
                    parentFeature = (SimpleFeature)childGrom2closestGeom.get((Object)childGeom);
                } else {
                    parentFeature = SpatialUtils.findClosestNeighboorVariableBuffer((Geometry)childGeom, (SimpleFeatureSource)datastoreParents.getFeatureSource((Name)datastoreParents.getNames().get(0)), (int)maxDistance);
                    childGrom2closestGeom.put((Object)childGeom, (Object)parentFeature);
                }
                if (parentFeature != null) {
                    System.out.println("\t me! " + parentFeature.getAttribute(1) + " " + parentFeature.getAttribute(0));
                    Integer idParent = (Integer)parentFeature.getAttribute(idxAttributeIdParent);
                    containerLinks.addRowToTable(MultilevelUtils.getRowForLink((String)("Link " + (previousLinksCount + containerLinks.size())), (DataCell)cellLinkTypeProximity, (Integer)idChild, (DataCell)cellEntityTypeChild, (Integer)idParent, (DataCell)cellEntityTypeParent));
                    continue;
                }
                orphanIds.add(idChild);
            }
            itChild.close();
        } else {
            SimpleFeatureIterator itChild = datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)).getFeatures().features();
            execProgressMatchingTwo.setMessage("counting orphans");
            while (itChild.hasNext()) {
                SimpleFeature childFeature = (SimpleFeature)itChild.next();
                Integer idChild = (Integer)childFeature.getAttribute(idxAttributeIdChild);
                if (!childWithParent.contains(idChild)) {
                    orphanIds.add(idChild);
                }
                if (idChild % 50 != 0) continue;
                execProgressMatchingTwo.setProgress((double)idChild.intValue() / (double)totalChildren);
                execProgressMatchingTwo.checkCanceled();
            }
        }
        execProgressMatchingTwo.setProgress(1.0);
        datastoreParents.dispose();
        datastoreChildren.dispose();
        containerLinks.close();
        if (!orphanIds.isEmpty()) {
            this.setWarningMessage(SpatialComposerUtils.getWarningMessageForOrphans(orphanIds));
        }
        BufferedDataTable linksNew = exec.createConcatenateTable(execProgressMatchingTwo, new BufferedDataTable[]{previousTableLinks, containerLinks.getTable()});
        BufferedDataTable linksNewRenamed = exec.createSpecReplacerTable(linksNew, MultilevelUtils.getSpecsForLinksTable());
        multilevelRes.replaceLinksTable(linksNewRenamed);
        return new MultilevelPopulationPortObject[]{multilevelRes};
    }

    protected void reset() {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_linkTypeInside.saveSettingsTo(settings);
        this.m_linkTypeProximity.saveSettingsTo(settings);
        this.m_parentName.saveSettingsTo(settings);
        this.m_childName.saveSettingsTo(settings);
        this.m_distance.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_linkTypeInside.loadSettingsFrom(settings);
        this.m_linkTypeProximity.loadSettingsFrom(settings);
        this.m_parentName.loadSettingsFrom(settings);
        this.m_childName.loadSettingsFrom(settings);
        this.m_distance.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_linkTypeInside.validateSettings(settings);
        this.m_linkTypeProximity.validateSettings(settings);
        this.m_parentName.validateSettings(settings);
        this.m_childName.validateSettings(settings);
        this.m_distance.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

