/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.multilevel.spatial.viewMultilevel;

import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelPopulationPortObject;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.geotools.data.DataStore;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.knime.core.util.FileUtil;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DisplaySpatialPopulationMultilevelNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(DisplaySpatialPopulationMultilevelNodeModel.class);
    protected Map<String, File> entityType2storageFile = new HashMap();
    protected Map<String, DataStore> entityType2datastore = new HashMap();

    protected DisplaySpatialPopulationMultilevelNodeModel() {
        super(new PortType[]{MultilevelPopulationPortObject.TYPE}, new PortType[0]);
    }

    protected PortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        MultilevelPopulationPortObject multilevel = null;
        try {
            multilevel = (MultilevelPopulationPortObject)inObjects[0];
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("The input should be a multilevel population", e);
        }
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (String entitytype : multilevel.getEntityTypes()) {
            DataTable tableEntity = multilevel.getTableForEntityType(entitytype);
            if (!SpatialUtils.hasGeometry((DataTableSpec)tableEntity.getDataTableSpec()) || !SpatialUtils.hasCRS((DataTableSpec)tableEntity.getDataTableSpec())) continue;
            CoordinateReferenceSystem crsOrig = SpatialUtils.decodeCRS((DataTableSpec)tableEntity.getDataTableSpec());
            File tmpFile = FileUtil.createTempFile((String)"shapefile", (String)".shp");
            this.entityType2storageFile.put(entitytype, tmpFile);
            DataStore datastore = SpatialUtils.createDataStore((File)tmpFile, (boolean)false);
            this.entityType2datastore.put(entitytype, datastore);
            Runnable runnableSpatialize1 = SpatialUtils.decodeAsFeaturesRunnable((BufferedDataTable)exec.createBufferedDataTable(tableEntity, exec.createSilentSubProgress(0.0)), (String)"the_geom", (ExecutionMonitor)exec.createSilentSubProgress(0.0), (DataStore)datastore, (String)entitytype, (CoordinateReferenceSystem)crsOrig, (boolean)false, null);
            executor.execute(runnableSpatialize1);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return new BufferedDataTable[0];
    }

    protected void disposeDatastores() {
        for (DataStore s : this.entityType2datastore.values()) {
            try {
                s.dispose();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.entityType2datastore.clear();
    }

    protected void reset() {
        this.disposeDatastores();
    }

    protected void onDispose() {
        this.disposeDatastores();
        super.onDispose();
    }

    protected PortObjectSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new PortObjectSpec[0];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        int i = 0;
        File bckp = new File(internDir, "datastore_" + i);
        while (bckp.exists() && bckp.canRead() && bckp.isFile()) {
            System.out.println("restoring datastore from " + bckp);
            File tmpFile = FileUtil.createTempFile((String)"shapefile", (String)".shp");
            FileUtil.copy((File)bckp, (File)tmpFile, (ExecutionMonitor)exec);
            DataStore datastore = SpatialUtils.createDataStore((File)tmpFile, (boolean)false);
            String entityType = "entity_" + i;
            this.entityType2storageFile.put(entityType, tmpFile);
            this.entityType2datastore.put(entityType, datastore);
            bckp = new File(internDir, "datastore_" + ++i);
        }
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        int i = 0;
        for (File shapefile : this.entityType2storageFile.values()) {
            File bckp = new File(internDir, "datastore_" + ++i);
            FileUtil.copy((File)shapefile, (File)bckp, (ExecutionMonitor)exec.createSilentSubProgress(0.0));
        }
    }
}

