/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.multilevel.spatial.viewMultilevel;

import ch.res_ear.samthiriot.knime.gosp.multilevel.spatial.viewMultilevel.DisplaySpatialPopulationMultilevelNodeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.eclipse.core.runtime.Platform;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.swing.JMapPane;
import org.geotools.swing.MapPane;
import org.geotools.swing.action.InfoAction;
import org.geotools.swing.action.NoToolAction;
import org.geotools.swing.action.PanAction;
import org.geotools.swing.action.ResetAction;
import org.geotools.swing.action.ZoomInAction;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.tool.InfoTool;
import org.geotools.swing.tool.PanTool;
import org.geotools.swing.tool.ScrollWheelTool;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeView;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

public class DisplaySpatialPopulationMultilevelNodeView
extends NodeView<DisplaySpatialPopulationMultilevelNodeModel> {
    private static final NodeLogger logger = NodeLogger.getLogger(DisplaySpatialPopulationMultilevelNodeView.class);
    private MapContent content = new MapContent();
    private JMapPane mapPane = null;

    protected DisplaySpatialPopulationMultilevelNodeView(DisplaySpatialPopulationMultilevelNodeModel nodeModel) {
        super((NodeModel)nodeModel);
        StreamingRenderer renderer = new StreamingRenderer();
        this.mapPane = new JMapPane(this.content);
        this.mapPane.setRenderer((GTRenderer)renderer);
        this.mapPane.addMouseListener((MapMouseListener)new ScrollWheelTool(this.mapPane));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.mapPane.setPreferredSize(new Dimension(screenSize.width * 2 / 3, screenSize.height * 2 / 3));
        this.setComponent((Component)this.mapPane);
        try {
            JMenuBar menuBar = this.getJMenuBar();
            ButtonGroup group = new ButtonGroup();
            JMenu menu = new JMenu("Spatial tools");
            menu.setMnemonic('S');
            JMenuItem resetMenu = new JMenuItem("Zoom to fit");
            ResetAction a = new ResetAction((MapPane)this.mapPane);
            resetMenu.setIcon((Icon)a.getValue("SmallIcon"));
            resetMenu.addActionListener((ActionListener)a);
            menu.add(resetMenu);
            menu.addSeparator();
            JRadioButtonMenuItem noToolMenu = new JRadioButtonMenuItem(NoToolAction.TOOL_NAME);
            a = new NoToolAction((MapPane)this.mapPane);
            group.add(noToolMenu);
            noToolMenu.setSelected(true);
            noToolMenu.setIcon((Icon)a.getValue("SmallIcon"));
            noToolMenu.addActionListener((ActionListener)a);
            menu.add(noToolMenu);
            JRadioButtonMenuItem panMenu = new JRadioButtonMenuItem(PanTool.TOOL_NAME);
            group.add(panMenu);
            try {
                panMenu.setIcon(new ImageIcon(ImageIO.read(Platform.getBundle((String)"ch.res_ear.samthiriot.knime.shapefilesAsWKT").getResource("/org/geotools/swing/icons/mActionPan.png").openStream())));
            }
            catch (IOException | IllegalArgumentException e) {
                logger.error((Object)"unable to load image resource /org/geotools/swing/icons/mActionPan.png", (Throwable)e);
                e.printStackTrace();
            }
            panMenu.setMnemonic('P');
            panMenu.addActionListener((ActionListener)new PanAction((MapPane)this.mapPane));
            menu.add(panMenu);
            JRadioButtonMenuItem infoMenu = new JRadioButtonMenuItem(InfoTool.TOOL_NAME);
            group.add(infoMenu);
            try {
                infoMenu.setIcon(new ImageIcon(ImageIO.read(Platform.getBundle((String)"ch.res_ear.samthiriot.knime.shapefilesAsWKT").getResource("/org/geotools/swing/icons/mActionIdentify.png").openStream())));
            }
            catch (IOException | IllegalArgumentException e) {
                logger.error((Object)"unable to load image resource /org/geotools/swing/icons/mActionIdentify.png", (Throwable)e);
                e.printStackTrace();
            }
            infoMenu.addActionListener((ActionListener)new InfoAction((MapPane)this.mapPane));
            menu.add(infoMenu);
            JRadioButtonMenuItem zoomInMenu = new JRadioButtonMenuItem("Zoom in");
            group.add(zoomInMenu);
            a = new ZoomInAction((MapPane)this.mapPane);
            zoomInMenu.setMnemonic('+');
            zoomInMenu.setIcon((Icon)a.getValue("SmallIcon"));
            zoomInMenu.addActionListener((ActionListener)a);
            menu.add(zoomInMenu);
            JRadioButtonMenuItem zoomOutMenu = new JRadioButtonMenuItem("Zoom out");
            group.add(zoomOutMenu);
            zoomOutMenu.setMnemonic('-');
            a = new ZoomInAction((MapPane)this.mapPane);
            zoomOutMenu.setIcon((Icon)a.getValue("SmallIcon"));
            zoomOutMenu.addActionListener((ActionListener)a);
            menu.add(zoomOutMenu);
            menuBar.add(menu);
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            logger.warn((Object)"unable to display toolbars");
        }
    }

    protected void modelChanged() {
        DisplaySpatialPopulationMultilevelNodeModel nodeModel = (DisplaySpatialPopulationMultilevelNodeModel)this.getNodeModel();
        assert (nodeModel != null);
    }

    protected void onClose() {
        this.content.dispose();
    }

    protected void onOpen() {
        DisplaySpatialPopulationMultilevelNodeModel nodeModel = (DisplaySpatialPopulationMultilevelNodeModel)this.getNodeModel();
        if (nodeModel == null) {
            return;
        }
        Color[] colors = new Color[]{Color.GRAY, Color.RED, Color.BLUE, Color.GREEN, Color.BLACK, Color.CYAN, Color.MAGENTA, Color.DARK_GRAY, Color.ORANGE, Color.PINK, Color.LIGHT_GRAY, Color.YELLOW};
        int i = 0;
        for (DataStore store : nodeModel.entityType2datastore.values()) {
            try {
                SimpleFeatureSource shapefileSource = store.getFeatureSource((Name)store.getNames().get(0));
                Style shpStyle = SLD.createSimpleStyle((FeatureType)shapefileSource.getSchema(), (Color)colors[i++ % colors.length]);
                FeatureLayer shpLayer = new FeatureLayer((FeatureSource)shapefileSource, shpStyle);
                this.content.addLayer((Layer)shpLayer);
            }
            catch (IOException | RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

