/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.multilevel2r;

import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelPopulationPortObject;
import ch.res_ear.samthiriot.knime.gosp.multilevel2r.RControllerWithMultilevel;
import ch.res_ear.samthiriot.knime.gosp.multilevel2r.RSnippetNodeConfigWithMultilevel;
import java.util.Arrays;
import java.util.LinkedList;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortType;
import org.knime.r.FlowVariableRepository;
import org.knime.r.RSnippetNodeConfig;
import org.knime.r.RSnippetNodeModel;
import org.knime.r.RSnippetSettings;
import org.knime.r.controller.IRController;
import org.knime.r.controller.RController;

public class RSnippetNodeModelWithMultilevel
extends RSnippetNodeModel {
    private RSnippetNodeConfigWithMultilevel m_config = null;

    public RSnippetNodeModelWithMultilevel(RSnippetNodeConfigWithMultilevel config) {
        super((RSnippetNodeConfig)config);
        this.m_config = config;
    }

    protected PortObject[] execute(PortObject[] inData, ExecutionContext exec) throws Exception {
        return this.executeInternal(this.getSettings(), inData, exec);
    }

    private PortObject[] executeInternal(RSnippetSettings settings, PortObject[] inData, ExecutionContext exec) throws Exception {
        this.getSettings().loadSettings(settings);
        FlowVariableRepository flowVarRepo = new FlowVariableRepository(this.getAvailableInputFlowVariables());
        controller.setUseNodeContext(true);
        try (RControllerWithMultilevel controller = new RControllerWithMultilevel();){
            exec.checkCanceled();
            PortObject[] out = this.executeSnippet((RController)controller, inData, flowVarRepo, exec);
            this.pushFlowVariables(flowVarRepo);
            PortObject[] portObjectArray = out;
            return portObjectArray;
        }
    }

    protected PortObject[] executeSnippet(RController controller, String script, PortObject[] inData, FlowVariableRepository flowVarRepo, ExecutionContext exec) throws Exception {
        PortObject[] res1 = super.executeSnippet(controller, script, inData, flowVarRepo, exec);
        LinkedList<Object> res2 = new LinkedList<Object>();
        res2.addAll(Arrays.asList(res1));
        for (PortType type : this.m_config.getOutPortTypes()) {
            if (!type.equals((Object)MultilevelPopulationPortObject.TYPE)) continue;
            res2.add(this.importDataFromR(controller, exec.createSubExecutionContext(0.3)));
        }
        return res2.toArray(new PortObject[res2.size()]);
    }

    private MultilevelPopulationPortObject importDataFromR(RController controller, ExecutionContext exec) throws IRController.RException, CanceledExecutionException {
        RControllerWithMultilevel controllerML = (RControllerWithMultilevel)controller;
        MultilevelPopulationPortObject out = controllerML.importMultilevelPopulation("knime.out", exec);
        return out;
    }
}

