/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.multilevel2r;

import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelPopulationPortObject;
import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelPopulationPortSpec;
import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelUtils;
import ch.res_ear.samthiriot.knime.gosp.multilevel2r.MultilevelTable2RUtils;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.knime.core.data.DataTable;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.port.PortObject;
import org.knime.r.controller.IRController;
import org.knime.r.controller.RController;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.RList;

public class RControllerWithMultilevel
extends RController {
    public RControllerWithMultilevel() throws IRController.RException {
    }

    public RControllerWithMultilevel(boolean useNodeContext) {
        super(useNodeContext);
    }

    public void importDataFromPorts(PortObject[] inData, ExecutionMonitor exec, int batchSize, String rType, boolean sendRowNames) throws IRController.RException, CanceledExecutionException {
        PortObject[] portObjectArray = inData;
        int n = inData.length;
        int n2 = 0;
        while (n2 < n) {
            PortObject port = portObjectArray[n2];
            if (port instanceof MultilevelPopulationPortObject) {
                exec.setMessage("Exporting multilevel table to R");
                ExecutionContext ctxt = (ExecutionContext)exec;
                MultilevelPopulationPortObject multilevel = (MultilevelPopulationPortObject)port;
                ExecutionMonitor execProgressConvertLinks = exec.createSubProgress(0.1);
                ExecutionMonitor execProgressLoadLinks = exec.createSubProgress(0.2);
                double progressSharedEntities = 0.6;
                exec.setMessage("loading links into R");
                BufferedDataTable bfLinks = MultilevelUtils.getAsBufferedDataTable((DataTable)multilevel.getTableLinks(), (ExecutionContext)ctxt, (ExecutionMonitor)execProgressConvertLinks);
                this.eval("knime.in <- list()", false);
                this.eval("knime.in$entities <- list()", false);
                exec.checkCanceled();
                this.monitoredAssign("knime.in$links", bfLinks, execProgressLoadLinks, batchSize, rType, sendRowNames);
                exec.checkCanceled();
                this.eval("knime.in$links$id_from <- factor(knime.in$links$id_from)", false);
                this.eval("knime.in$links$id_to <- factor(knime.in$links$id_to)", false);
                this.eval("knime.in$links$type_from <- factor(knime.in$links$type_from)", false);
                this.eval("knime.in$links$type_to <- factor(knime.in$links$type_to)", false);
                this.eval("knime.in$links$link_type <- factor(knime.in$links$link_type)", false);
                exec.checkCanceled();
                for (String type : multilevel.getEntityTypes()) {
                    exec.setMessage("loading entities " + type + " into R");
                    double totalProgressForType = 0.6 / (double)multilevel.getEntityTypes().size();
                    BufferedDataTable bfEntity = MultilevelUtils.getAsBufferedDataTable((DataTable)multilevel.getTableForEntityType(type), (ExecutionContext)ctxt, (ExecutionMonitor)exec.createSubProgress(totalProgressForType * 0.1));
                    exec.checkCanceled();
                    String tableName = "knime.in$entities$" + MultilevelTable2RUtils.getRNameForName((String)type);
                    this.monitoredAssign(tableName, bfEntity, exec.createSubProgress(totalProgressForType * 0.9), batchSize, rType, sendRowNames);
                    this.eval(String.valueOf(tableName) + "$id <- factor(" + tableName + "$id)", false);
                    exec.checkCanceled();
                }
            }
            ++n2;
        }
        exec.checkCanceled();
        super.importDataFromPorts(inData, exec, batchSize, rType, sendRowNames);
    }

    protected String getTypeOfRVariable(String variableName) throws IRController.RException, REXPMismatchException {
        REXP rTypes = this.eval("typeof(" + variableName + ")", true);
        String[] types = rTypes.asStrings();
        return types[0];
    }

    protected boolean isDataframe(String variableName) throws IRController.RException, REXPMismatchException {
        REXP rIs = this.eval("is.data.frame(" + variableName + ")", true);
        int[] types = rIs.asIntegers();
        return types[0] > 0;
    }

    public MultilevelPopulationPortObject importMultilevelPopulation(String string, ExecutionContext exec) throws CanceledExecutionException {
        MultilevelPopulationPortObject multilevel = null;
        try {
            List<String> listEntityTypesNames;
            ExecutionContext progressLinks = exec.createSubExecutionContext(0.1);
            exec.setMessage("Loading workspace from R input port");
            if (!"list".equals(this.getTypeOfRVariable("knime.out"))) {
                throw new IllegalArgumentException("the variable of knime.out is not a list as expected");
            }
            if (!this.isDataframe("knime.out$links")) {
                throw new IllegalArgumentException("the variable of knime.out$links is not a dataframe as expected");
            }
            if (!"list".equals(this.getTypeOfRVariable("knime.out$entities"))) {
                throw new IllegalArgumentException("the variable of knime.out$entities is not a list as expected");
            }
            exec.checkCanceled();
            REXP rListVars = this.eval("names(knime.out$entities)", true);
            if (rListVars instanceof REXPString) {
                listEntityTypesNames = new LinkedList<String>(Arrays.asList(rListVars.asStrings()));
            } else if (rListVars instanceof REXPList) {
                RList listVars = rListVars.asList();
                listEntityTypesNames = listVars.stream().map(o -> (String)o).collect(Collectors.toList());
            } else {
                throw new RuntimeException("unable to decode the list of variables using names(knime.out$entities)");
            }
            exec.checkCanceled();
            exec.setMessage("loading links");
            BufferedDataTable tableLinks = this.importBufferedDataTable("knime.out$links", true, progressLinks);
            exec.checkCanceled();
            multilevel = new MultilevelPopulationPortObject((DataTable)tableLinks, new MultilevelPopulationPortSpec());
            exec.checkCanceled();
            REXP rLinkTypes = this.eval("unique(knime.out$links[,c(\"link_type\")])", true);
            List<String> listTypes = Arrays.asList(rLinkTypes.asStrings());
            MultilevelPopulationPortObject multilevel2 = multilevel;
            listTypes.stream().map(o -> o).forEach(s -> multilevel2.declareLinkType(s));
            exec.checkCanceled();
            double progressPerType = 0.9 / (double)listEntityTypesNames.size();
            for (String type : listEntityTypesNames) {
                exec.setMessage("loading entities " + type);
                BufferedDataTable tableEntities = this.importBufferedDataTable("knime.out$entities$" + type, true, exec.createSubExecutionContext(progressPerType));
                multilevel.addPopulation(type, (DataTable)tableEntities);
                exec.checkCanceled();
            }
        }
        catch (IRController.RException | REXPMismatchException e) {
            e.printStackTrace();
            throw new RuntimeException("error when converting data from R: " + e.getMessage(), e);
        }
        return multilevel;
    }
}

