/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.multilevel2r;

import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelPopulationPortObject;
import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.knime.core.data.DataTable;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.util.FileUtil;
import org.knime.ext.r.node.local.port.RPortObject;
import org.knime.r.controller.IRController;
import org.knime.r.controller.RController;

/*
 * Exception performing whole class analysis ignored.
 */
public class MultilevelTable2RUtils {
    public static String getRNameForName(String name) {
        return name.replaceAll("/[^A-Za-z0-9 ]/", "_");
    }

    public static RPortObject copyMultilevelIntoR(RPortObject rPortObject, MultilevelPopulationPortObject multilevel, ExecutionContext exec) throws CanceledExecutionException, IRController.RException, IOException {
        RController controller = new RController(true);
        controller.initialize();
        int batchSize = 100000;
        String rType = "data.frame";
        boolean sendRowNames = false;
        ExecutionMonitor execProgressConvertLinks = exec.createSubProgress(0.1);
        ExecutionMonitor execProgressLoadLinks = exec.createSubProgress(0.2);
        double progressSharedEntities = 0.6;
        ExecutionMonitor execProgressSaveWorkspace = exec.createSubProgress(0.1);
        if (rPortObject != null) {
            exec.setMessage("Loading workspace from R input port");
            controller.eval("load(\"" + rPortObject.getFile().getAbsolutePath().replace('\\', '/') + "\")\n" + RController.createLoadLibraryFunctionCall((List)rPortObject.getLibraries(), (boolean)false), false);
        }
        exec.setMessage("loading links into R");
        BufferedDataTable bfLinks = MultilevelUtils.getAsBufferedDataTable((DataTable)multilevel.getTableLinks(), (ExecutionContext)exec, (ExecutionMonitor)execProgressConvertLinks);
        controller.monitoredAssign("multilevel.links", bfLinks, execProgressLoadLinks, 100000, "data.frame", false);
        for (String type : multilevel.getEntityTypes()) {
            exec.setMessage("loading entities " + type + " into R");
            double totalProgressForType = 0.6 / (double)multilevel.getEntityTypes().size();
            BufferedDataTable bfEntity = MultilevelUtils.getAsBufferedDataTable((DataTable)multilevel.getTableForEntityType(type), (ExecutionContext)exec, (ExecutionMonitor)exec.createSubProgress(totalProgressForType * 0.1));
            controller.monitoredAssign("multilevel." + MultilevelTable2RUtils.getRNameForName((String)type), bfEntity, exec.createSubProgress(totalProgressForType * 0.9), 100000, "data.frame", false);
        }
        File tempWorkspaceFile = FileUtil.createTempFile((String)"R-workspace", (String)".RData");
        exec.setMessage("saving R workspace");
        controller.saveWorkspace(tempWorkspaceFile, execProgressSaveWorkspace);
        controller.close();
        return new RPortObject(tempWorkspaceFile, Collections.emptyList());
    }
}

