/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp;

import ch.res_ear.samthiriot.knime.gosp.IWarningWriter;
import java.util.LinkedHashSet;
import java.util.List;
import org.knime.core.node.NodeLogger;

public class NodeWarningWriter
implements IWarningWriter {
    private final NodeLogger logger;
    private LinkedHashSet<String> messages = new LinkedHashSet();
    public static final int MAX_MESSAGES = 100;

    public NodeWarningWriter(NodeLogger logger) {
        this.logger = logger;
    }

    public void warn(String s) {
        int size = this.messages.size();
        if (size == 100) {
            this.messages.add("[...]");
        } else if (size < 100 && this.messages.add(s)) {
            this.logger.warn((Object)s);
        }
    }

    public String buildWarnings() {
        if (this.messages.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (String s : this.messages) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public void addWarnings(List<String> configWarnings) {
        for (String s : configWarnings) {
            this.warn(s);
        }
    }
}

