/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.sample.roulettewheel;

import ch.res_ear.samthiriot.knime.gosp.AbstractWeightedRandomSampling;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.knime.base.data.sort.SortedTable;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.container.ColumnRearranger;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;

public class RouletteWheelSampling
extends AbstractWeightedRandomSampling {
    public RouletteWheelSampling(boolean autoseed, int providedSeed, boolean removeWeightColumn, String colnameWeight, boolean shuffle, DataTableSpec spec, double sum) {
        super(autoseed, providedSeed, removeWeightColumn, colnameWeight, shuffle, spec, sum);
    }

    public RouletteWheelSampling(boolean autoseed, int providedSeed, boolean removeWeightColumn, String colnameWeight, boolean shuffle, DataTableSpec spec) {
        super(autoseed, providedSeed, removeWeightColumn, colnameWeight, shuffle, spec);
    }

    public BufferedDataTable execute(BufferedDataTable sample, int toDraw, ExecutionContext exec) throws CanceledExecutionException {
        if (toDraw == 0) {
            return exec.createVoidTable(this.getTableSpecExternal(sample.getDataTableSpec()));
        }
        ExecutionContext execParentSampling = exec.createSubExecutionContext(this.shuffle ? 0.5 : 1.0);
        ExecutionContext execParentShuffling = exec.createSubExecutionContext(this.shuffle ? 0.5 : 0.0);
        ExecutionContext execSum = execParentSampling.createSubExecutionContext(0.2);
        ExecutionContext execDraw = execParentSampling.createSubExecutionContext(0.1);
        ExecutionContext execSortWeights = execParentSampling.createSubExecutionContext(0.1);
        ExecutionContext execCopy = execParentSampling.createSubExecutionContext(0.6);
        ExecutionContext execSort = execParentShuffling.createSubExecutionContext(0.3);
        ExecutionContext execRemoveColWeight = execParentShuffling.createSubExecutionContext(0.3);
        double totalSum = this.getSum(sample, execSum);
        List weights = this.sampleN(toDraw, totalSum, execDraw);
        execSortWeights.setProgress(0.0, "sorting weights");
        Collections.sort(weights);
        execSortWeights.setProgress(1.0, "sorting weights");
        BufferedDataContainer container = exec.createDataContainer(this.getTableSpecInternal(sample.getDataTableSpec()));
        Iterator itWeight = weights.iterator();
        itWeight.hasNext();
        double currentWeight = (Double)itWeight.next();
        CloseableRowIterator itRow = sample.iterator();
        double sum = 0.0;
        long current = 0L;
        exec.setMessage("copying");
        DataRow row = null;
        block0: while (itRow.hasNext()) {
            row = itRow.next();
            double w = ((DoubleValue)row.getCell(this.idxWeight)).getDoubleValue();
            sum += w;
            while (currentWeight <= sum) {
                container.addRowToTable(this.getRowToStore("row_" + current, row));
                if (!itWeight.hasNext()) break block0;
                currentWeight = (Double)itWeight.next();
                if (current % 50L == 0L) {
                    execCopy.setProgress((double)current / (double)toDraw, "copying " + current + "/" + toDraw);
                    exec.checkCanceled();
                }
                ++current;
            }
        }
        while (container.size() < (long)toDraw) {
            container.addRowToTable(this.getRowToStore("row_" + current, row));
            ++current;
            if (!itWeight.hasNext()) continue;
            currentWeight = (Double)itWeight.next();
        }
        itRow.close();
        container.close();
        BufferedDataTable sampled = container.getTable();
        if (container.size() != (long)toDraw) {
            throw new RuntimeException("Wrong final count: expecting " + toDraw + ", sampled " + container.size());
        }
        if (this.shuffle) {
            BufferedDataTable bfShuffledWithWeights;
            exec.setMessage("shuffling the results");
            SortedTable suffledWithWeight = new SortedTable(sampled, Arrays.asList("___weight____"), new boolean[]{true}, execSort);
            sampled = bfShuffledWithWeights = suffledWithWeight.getBufferedDataTable();
        }
        ColumnRearranger rearranger = new ColumnRearranger(sampled.getDataTableSpec());
        if (this.removeWeightColumn) {
            rearranger.remove(new String[]{this.colnameWeight});
        }
        if (this.shuffle) {
            rearranger.remove(new String[]{"___weight____"});
        }
        exec.setMessage("removing the shuffling random weight");
        BufferedDataTable bf = exec.createColumnRearrangeTable(sampled, rearranger, (ExecutionMonitor)execRemoveColWeight);
        exec.setMessage("freeing temporary data");
        exec.setMessage("done weighted sampling");
        return bf;
    }
}

