/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.sample.roulettewheel;

import ch.res_ear.samthiriot.knime.gosp.sample.roulettewheel.RouletteWheelSampling;
import java.io.File;
import java.io.IOException;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class WeightedSampleRouletteWheelNodeModel
extends NodeModel {
    private final SettingsModelString m_columnForWeight = new SettingsModelString("col_weight", null);
    private final SettingsModelIntegerBounded m_count = new SettingsModelIntegerBounded("count", 10000, 0, Integer.MAX_VALUE);
    private final SettingsModelBoolean m_removeWeight = new SettingsModelBoolean("remove_weight_col", true);
    private final SettingsModelBoolean m_autoseed = new SettingsModelBoolean("seed_auto", true);
    private final SettingsModelIntegerBounded m_seed = new SettingsModelIntegerBounded("seed", 55555, Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final SettingsModelBoolean m_shuffleResult = new SettingsModelBoolean("shuffle", true);

    protected WeightedSampleRouletteWheelNodeModel() {
        super(1, 1);
    }

    private DataTableSpec getTableSpec(DataTableSpec spec) {
        boolean removeWeightCol = this.m_removeWeight.getBooleanValue();
        if (!removeWeightCol) {
            return spec;
        }
        String colNameWeight = this.m_columnForWeight.getStringValue();
        if (colNameWeight == null) {
            return null;
        }
        DataColumnSpec[] novelSpecs = new DataColumnSpec[spec.getNumColumns() - 1];
        int j = 0;
        int i = 0;
        while (i < spec.getNumColumns()) {
            if (!colNameWeight.equals(spec.getColumnSpec(i).getName())) {
                novelSpecs[j++] = spec.getColumnSpec(i);
            }
            ++i;
        }
        return new DataTableSpec(spec.getName(), novelSpecs);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            return new DataTableSpec[1];
        }
        return new DataTableSpec[]{this.getTableSpec(spec)};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable sample = inData[0];
        RouletteWheelSampling samplingEngine = new RouletteWheelSampling(this.m_autoseed.getBooleanValue(), this.m_seed.getIntValue(), this.m_removeWeight.getBooleanValue(), this.m_columnForWeight.getStringValue(), this.m_shuffleResult.getBooleanValue(), sample.getDataTableSpec());
        BufferedDataTable sampled = samplingEngine.execute(sample, this.m_count.getIntValue(), exec);
        return new BufferedDataTable[]{sampled};
    }

    protected void reset() {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_columnForWeight.saveSettingsTo(settings);
        this.m_count.saveSettingsTo(settings);
        this.m_removeWeight.saveSettingsTo(settings);
        this.m_autoseed.saveSettingsTo(settings);
        this.m_seed.saveSettingsTo(settings);
        this.m_shuffleResult.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_columnForWeight.loadSettingsFrom(settings);
        this.m_count.loadSettingsFrom(settings);
        this.m_removeWeight.loadSettingsFrom(settings);
        this.m_autoseed.loadSettingsFrom(settings);
        this.m_seed.loadSettingsFrom(settings);
        this.m_shuffleResult.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_columnForWeight.validateSettings(settings);
        this.m_count.validateSettings(settings);
        this.m_removeWeight.validateSettings(settings);
        this.m_autoseed.validateSettings(settings);
        this.m_seed.validateSettings(settings);
        this.m_shuffleResult.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

