/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.decodewWithDico;

import ch.res_ear.samthiriot.knime.gosp.NodeWarningWriter;
import ch.res_ear.samthiriot.knime.gosp.decodewWithDico.Dictionary;
import ch.res_ear.samthiriot.knime.gosp.decodewWithDico.DictionaryForVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.InvalidSettingsException;

public class Dictionary {
    private Map<String, DictionaryForVariable<?>> code2dico = new HashMap();
    private final NodeWarningWriter warnings;

    public DictionaryForVariable<?> getDictionaryForVariable(String variableName) {
        return (DictionaryForVariable)this.code2dico.get(variableName);
    }

    public Dictionary(BufferedDataTable bf, String columnNameVariableCode, String columnNameVariableLabel, String columnNameModalityCode, String columnNameModalityLabel, String columnNameType, String columnNameMissing, NodeWarningWriter warnings) throws InvalidSettingsException {
        this.warnings = warnings;
        this.decodeFromBF(bf, columnNameVariableCode, columnNameVariableLabel, columnNameModalityCode, columnNameModalityLabel, columnNameType, columnNameMissing);
    }

    protected List<DataColumnSpec> getSpecsDecodedFromColumn(List<DataColumnSpec> origSpecs) {
        ArrayList<DataColumnSpec> res = new ArrayList<DataColumnSpec>(origSpecs.size());
        int col = 0;
        while (col < origSpecs.size()) {
            DataColumnSpec specOrig = origSpecs.get(col);
            DictionaryForVariable dico = (DictionaryForVariable)this.code2dico.get(specOrig.getName());
            if (dico == null) {
                res.add(specOrig);
            } else {
                res.add(dico.getSpecDecodedFromColumn(specOrig));
            }
            ++col;
        }
        return res;
    }

    protected void addDictionaryForVariable(DictionaryForVariable<?> forVar) {
        System.out.println("added dico: " + forVar);
        this.code2dico.put(forVar.variableName, forVar);
    }

    protected Type decodeType(DataCell cellType) {
        if (cellType.isMissing()) {
            return null;
        }
        String content = cellType.toString().trim().toLowerCase();
        if (content.isEmpty()) {
            return null;
        }
        if (content.startsWith("int")) {
            return Type.INT;
        }
        if (content.equals("float") || content.equals("double")) {
            return Type.DOUBLE;
        }
        if (content.equals("bool") || content.equals("boolean") || content.equals("binary")) {
            return Type.BOOLEAN;
        }
        if (content.equals("string") || content.equals("char")) {
            return Type.STRING;
        }
        if (content.startsWith("auto")) {
            return Type.AUTO;
        }
        return null;
    }

    protected void decodeFromBF(BufferedDataTable bf, String columnNameVariableCode, String columnNameVariableLabel, String columnNameModalityCode, String columnNameModalityLabel, String columnNameType, String columnNameMissing) throws InvalidSettingsException {
        DataTableSpec spec = bf.getDataTableSpec();
        int idxVariableCode = spec.findColumnIndex(columnNameVariableCode);
        int idxVariableLabel = spec.findColumnIndex(columnNameVariableLabel);
        int idxModalityCode = spec.findColumnIndex(columnNameModalityCode);
        int idxModalityLabel = spec.findColumnIndex(columnNameModalityLabel);
        int idxType = spec.findColumnIndex(columnNameType);
        int idxMissing = spec.findColumnIndex(columnNameMissing);
        try (CloseableRowIterator it = bf.iterator();){
            String ongoingVariableCode = null;
            String ongoingVariableLabel = null;
            LinkedHashMap<String, String> ongoingMissing = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> ongoingModalityEncodedToDecoded = new LinkedHashMap<String, String>();
            Type ongoingType = null;
            while (it.hasNext()) {
                DataRow row = it.next();
                String currentVariableCode = row.getCell(idxVariableCode).toString().trim();
                String currentVariableLabel = row.getCell(idxVariableLabel).toString().trim();
                String currentModalityCode = row.getCell(idxModalityCode).toString().trim();
                String currentModalityLabel = row.getCell(idxModalityLabel).toString().trim();
                DataCell currentType = row.getCell(idxType);
                DataCell currentMissing = row.getCell(idxMissing);
                if (!currentVariableCode.equals(ongoingVariableCode)) {
                    if (ongoingVariableCode != null) {
                        this.addDictionaryForVariable(new DictionaryForVariable(ongoingVariableCode, ongoingVariableLabel, ongoingMissing, ongoingModalityEncodedToDecoded, ongoingType, this.warnings));
                    }
                    if (this.code2dico.containsKey(currentVariableCode)) {
                        throw new InvalidSettingsException("The variable " + currentVariableCode + " is declared several times; please ensure the lines corresponding the same variable are contiguous");
                    }
                    ongoingVariableCode = currentVariableCode;
                    ongoingVariableLabel = currentVariableLabel;
                    ongoingMissing.clear();
                    ongoingModalityEncodedToDecoded.clear();
                    ongoingType = null;
                }
                currentVariableLabel.contentEquals(ongoingVariableLabel);
                if (!currentMissing.isMissing() && !currentMissing.toString().trim().isEmpty()) {
                    ongoingMissing.put(currentModalityCode, currentModalityLabel);
                } else {
                    ongoingModalityEncodedToDecoded.put(currentModalityCode, currentModalityLabel);
                }
                Type decoded = this.decodeType(currentType);
                if (decoded == null) continue;
                if (ongoingType != null && ongoingType != decoded) {
                    throw new IllegalArgumentException("for variable " + ongoingVariableCode + " (" + ongoingVariableLabel + "), there are multiple incompatible types declarations");
                }
                ongoingType = decoded;
            }
            this.addDictionaryForVariable(new DictionaryForVariable(ongoingVariableCode, ongoingVariableLabel, ongoingMissing, ongoingModalityEncodedToDecoded, ongoingType, this.warnings));
        }
    }
}

