/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_gml;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.FeaturesDecodingUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.wfs.GML;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnProperties;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.MissingCell;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.util.FileUtil;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.SAXException;

public class ReadGMLAsWKTNodeModel
extends NodeModel {
    private static final int SAMPLE_LINES_GML = 10;
    private final SettingsModelString m_file = new SettingsModelString("filename", null);
    protected final SettingsModelBoolean m_skipStandardColumns = new SettingsModelBoolean("skip_standard", true);
    private static final Set<String> IGNORED_PROPERTIES = new HashSet<String>(Arrays.asList("Feature", "LookAt", "Style", "Region", "description", "boundedBy", "name"));

    protected ReadGMLAsWKTNodeModel() {
        super(0, 1);
    }

    protected SimpleFeatureIterator getFeaturesIterator() throws InvalidSettingsException {
        InputStream inputStream;
        URL filename;
        try {
            filename = FileUtil.toURL((String)this.m_file.getStringValue());
        }
        catch (MalformedURLException | InvalidPathException e2) {
            e2.printStackTrace();
            throw new InvalidSettingsException("unable to open URL " + this.m_file.getStringValue() + ": " + e2.getMessage());
        }
        if (filename == null) {
            throw new InvalidSettingsException("no file defined");
        }
        try {
            inputStream = FileUtil.openStreamWithTimeout((URL)filename);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new IllegalArgumentException("unable to open the URL " + filename + ": " + e2.getMessage());
        }
        GML gml = new GML(GML.Version.GML3);
        gml.setLegacy(true);
        SimpleFeatureIterator iter = null;
        try {
            iter = gml.decodeFeatureIterator(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new InvalidSettingsException("unable to decode the file as GML: " + e.getMessage(), (Throwable)e);
        }
        return iter;
    }

    protected DataTableSpec decodeSpecsFromGML() throws InvalidSettingsException {
        boolean skipStandardColumns = this.m_skipStandardColumns.getBooleanValue();
        SimpleFeatureIterator iter = this.getFeaturesIterator();
        LinkedHashMap<String, DataColumnSpec> name2spec = new LinkedHashMap<String, DataColumnSpec>();
        name2spec.put("id", new DataColumnSpecCreator("id", StringCell.TYPE).createSpec());
        CoordinateReferenceSystem crs = null;
        int done = 0;
        while (iter.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iter.next();
            CoordinateReferenceSystem currentCRS = feature.getType().getCoordinateReferenceSystem();
            if (currentCRS != null) {
                if (crs == null) {
                    crs = currentCRS;
                    DataColumnSpecCreator creatorGeom = new DataColumnSpecCreator("the_geom", StringCell.TYPE);
                    HashMap<String, String> properties = new HashMap<String, String>();
                    properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crs));
                    properties.put("crs WKT", crs.toWKT());
                    DataColumnProperties propertiesKWT = new DataColumnProperties(properties);
                    creatorGeom.setProperties(propertiesKWT);
                    name2spec.put("the_geom", creatorGeom.createSpec());
                    this.getLogger().info((Object)("detected Coordinate Reference System " + crs));
                } else if (!crs.equals(currentCRS)) {
                    throw new InvalidSettingsException("invalid GML file: found several different Coordinate Reference System for different features");
                }
            }
            for (Property property : feature.getProperties()) {
                String name = property.getName().toString();
                if (skipStandardColumns && IGNORED_PROPERTIES.contains(name)) {
                    this.getLogger().info((Object)("will skip column " + name + " which is assumed to be automatically created but useless"));
                    continue;
                }
                DataColumnSpec columnSpec = FeaturesDecodingUtils.getColumnSpecForFeatureProperty((Property)property, (String)name, (NodeLogger)this.getLogger());
                DataColumnSpec previousSpec = (DataColumnSpec)name2spec.get(name);
                if (previousSpec != null) {
                    if (previousSpec.getType().equals((Object)columnSpec.getType())) continue;
                    throw new InvalidSettingsException("invalid GML file: the property " + name + " has different types " + previousSpec.getType() + " and " + columnSpec.getType());
                }
                name2spec.put(name, columnSpec);
            }
            if (done++ >= 10) break;
        }
        iter.close();
        return new DataTableSpec("GML entities", name2spec.values().toArray(new DataColumnSpec[name2spec.size()]));
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        DataTableSpec tableSpec = this.decodeSpecsFromGML();
        BufferedDataContainer container = exec.createDataContainer(tableSpec);
        MissingCell missing = new MissingCell("was undefined in GML");
        CoordinateReferenceSystem crs = null;
        int line = 0;
        try (SimpleFeatureIterator iter = this.getFeaturesIterator();){
            while (iter.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iter.next();
                ArrayList<Object> cells = new ArrayList<Object>(tableSpec.getNumColumns());
                CoordinateReferenceSystem currentCRS = feature.getType().getCoordinateReferenceSystem();
                if (crs == null) {
                    crs = currentCRS;
                    this.getLogger().info((Object)("detected as Coordinate Reference System: " + currentCRS));
                } else if (!crs.equals(currentCRS)) {
                    throw new InvalidSettingsException("invalid GML file: found several different Coordinate Reference System for different features");
                }
                if (feature.getDefaultGeometry() == null) {
                    this.getLogger().warn((Object)("ignoring a feature which has no geometry: " + feature));
                    continue;
                }
                int col = 0;
                while (col < tableSpec.getNumColumns()) {
                    DataColumnSpec colSpec = tableSpec.getColumnSpec(col);
                    String name = colSpec.getName();
                    Property property = feature.getProperty(name);
                    Geometry geom = (Geometry)feature.getDefaultGeometry();
                    DataCell cell = null;
                    if ("id".equals(name)) {
                        cell = StringCell.StringCellFactory.create((String)feature.getID());
                    } else if ("the_geom".equals(name)) {
                        cell = StringCell.StringCellFactory.create((String)geom.toString());
                    } else if (property != null) {
                        cell = FeaturesDecodingUtils.getDataCellForProperty((Property)property, (SimpleFeature)feature);
                    }
                    if (cell == null) {
                        cells.add(missing);
                    } else {
                        cells.add(cell);
                    }
                    ++col;
                }
                container.addRowToTable((DataRow)new DefaultRow(new RowKey("Row_" + line), cells));
                if (line++ % 10 != 0) continue;
                exec.checkCanceled();
                exec.setMessage("reading GML entity " + line);
            }
        }
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec specs = this.decodeSpecsFromGML();
        return new DataTableSpec[]{specs};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_file.saveSettingsTo(settings);
        this.m_skipStandardColumns.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.loadSettingsFrom(settings);
        this.m_skipStandardColumns.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.validateSettings(settings);
        this.m_skipStandardColumns.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

