/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.create.geocoding;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.jdbcx.JdbcConnectionPool;
import org.knime.core.node.NodeLogger;

public abstract class GeocodingCache<T> {
    public final String tablename;
    public final String name;
    private final NodeLogger logger = NodeLogger.getLogger(GeocodingCache.class);
    private Connection conn = null;
    private PreparedStatement preparedStatementReadOSMGeocoding = null;
    private PreparedStatement preparedStatementWriteOSMGeocoding = null;
    private PreparedStatement preparedStatementUpdateOSMGeocoding = null;

    public GeocodingCache(String name, String tablename) {
        this.name = name;
        this.tablename = tablename;
        String tmpDir = this.getStorageDir();
        String filename = String.valueOf(tmpDir) + File.separator + "knime_geocoding_cache.h2";
        JdbcConnectionPool cp = JdbcConnectionPool.create((String)("jdbc:h2:" + filename), (String)"sa", (String)"sa");
        try {
            this.conn = cp.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.warn((Object)("unable to create the H2 cache for JSON geocoding: " + e.getLocalizedMessage()), (Throwable)e);
            return;
        }
        try {
            Statement st = this.conn.createStatement();
            st.execute("CREATE TABLE IF NOT EXISTS " + tablename + "(" + "ADDRESS VARCHAR(255) PRIMARY KEY, " + "RESULT other);");
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.warn((Object)("unable to create the table for OSM cache:" + e.getLocalizedMessage()), (Throwable)e);
            return;
        }
        try {
            this.preparedStatementReadOSMGeocoding = this.conn.prepareStatement("SELECT * FROM " + tablename + " WHERE ADDRESS = ?");
            this.preparedStatementWriteOSMGeocoding = this.conn.prepareStatement("INSERT INTO " + tablename + " VALUES(?,?)");
            this.preparedStatementUpdateOSMGeocoding = this.conn.prepareStatement("UPDATE " + tablename + " SET RESULT=? WHERE ADDRESS = ?");
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.logger.warn((Object)("unable to prepare the statements for OSM cache: " + e.getLocalizedMessage()), (Throwable)e);
        }
        this.logger.info((Object)"cache for OSM geocoding queries is up");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getOSMGeocodingForAddress(String address) {
        ResultSet rs;
        block8: {
            if (this.conn == null || this.preparedStatementReadOSMGeocoding == null) {
                return null;
            }
            if (address.length() > 255) {
                return null;
            }
            rs = null;
            try {
                this.preparedStatementReadOSMGeocoding.setString(1, address);
                rs = this.preparedStatementReadOSMGeocoding.executeQuery();
                if (rs.next()) break block8;
                return null;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
                return null;
            }
        }
        try {
            try {
                return (T)rs.getObject("RESULT");
            }
            catch (SQLException e) {
                e.printStackTrace();
                this.logger.warn((Object)("error when searching for cached " + address + ": " + e.getLocalizedMessage()), (Throwable)e);
                return null;
            }
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            this.logger.warn((Object)"the database contains obsolete java classes; clearing cache");
            this.clearCache();
            return null;
        }
    }

    public void storeInCache(String address, T result) {
        if (this.conn == null || this.preparedStatementWriteOSMGeocoding == null) {
            return;
        }
        if (result == null) {
            return;
        }
        if (address.length() > 255) {
            this.logger.warn((Object)("will not cache this address which is too long (more than 255 char): " + address));
            return;
        }
        try {
            this.preparedStatementWriteOSMGeocoding.setString(1, address);
            this.preparedStatementWriteOSMGeocoding.setObject(2, result);
            this.preparedStatementWriteOSMGeocoding.execute();
        }
        catch (SQLException e) {
            try {
                this.preparedStatementUpdateOSMGeocoding.setObject(1, result);
                this.preparedStatementUpdateOSMGeocoding.setString(2, address);
                this.preparedStatementUpdateOSMGeocoding.execute();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
                this.logger.warn((Object)("unable to cache the OSM result for address " + address));
            }
        }
    }

    public void clearCache() {
        try {
            Statement st = this.conn.createStatement();
            st.executeQuery("TRUNCATE TABLE " + this.tablename);
        }
        catch (SQLException e1) {
            e1.printStackTrace();
            this.logger.error((Object)"unable to truncate the cache table; please delete the file manually");
        }
    }

    protected void finalize() throws Throwable {
        if (this.conn != null) {
            this.conn.close();
        }
        super.finalize();
    }

    private String getStorageDir() {
        String basedir = System.getProperty("LOCALAPPDATA");
        if (basedir == null) {
            basedir = System.getProperty("APPDATA");
        }
        if (basedir == null) {
            basedir = String.valueOf(System.getProperty("user.home")) + File.separator + ".knime";
        }
        this.logger.info((Object)("will store the cache of OpenStreetMap geocoding in " + basedir));
        return basedir;
    }
}

