/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.transform.filter_ecql;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.knime.base.util.flowvariable.FlowVariableProvider;
import org.knime.base.util.flowvariable.FlowVariableResolver;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FilterECQLNodeModel
extends NodeModel
implements FlowVariableProvider {
    private SettingsModelString m_query = new SettingsModelString("query", "area(the_geom) < 15");

    protected FilterECQLNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec)) {
            throw new InvalidSettingsException("the input table does not contains WKT spatial data");
        }
        this.getFilter();
        return new DataTableSpec[]{spec};
    }

    protected Filter getFilter() throws InvalidSettingsException {
        String query = this.m_query.getStringValue();
        String queryWithVariableValues = FlowVariableResolver.parse((String)query, (FlowVariableProvider)this);
        Filter filter = null;
        try {
            filter = ECQL.toFilter((String)queryWithVariableValues);
        }
        catch (CQLException e) {
            throw new InvalidSettingsException("invalid CQL query: " + e.getMessage(), (Throwable)e);
        }
        return filter;
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inputPopulation = inData[0];
        DataStore datastore = SpatialUtils.createTmpDataStore((boolean)false);
        ExecutionContext execSpatialize = exec.createSubExecutionContext(0.5);
        ExecutionContext execFilter = exec.createSubExecutionContext(0.5);
        CoordinateReferenceSystem crs = SpatialUtils.decodeCRS((DataTableSpec)inputPopulation.getDataTableSpec());
        Filter filter = this.getFilter();
        exec.setMessage("spatializing features");
        SpatialUtils.decodeAsFeatures((BufferedDataTable)inputPopulation, (String)"the_geom", (ExecutionMonitor)execSpatialize, (DataStore)datastore, (String)"entities", (CoordinateReferenceSystem)crs);
        exec.setMessage("filtering");
        SimpleFeatureCollection features = datastore.getFeatureSource((Name)datastore.getNames().get(0)).getFeatures(filter);
        BufferedDataContainer container = exec.createDataContainer(inputPopulation.getDataTableSpec());
        CloseableRowIterator itRow = inputPopulation.iterator();
        SimpleFeatureIterator itFeatures = features.features();
        double total = inputPopulation.size();
        int done = 0;
        try {
            String rowid = null;
            while (itRow.hasNext()) {
                DataRow row;
                if (done++ % 10 == 0) {
                    exec.checkCanceled();
                    execFilter.setProgress((double)done / total);
                }
                if (rowid == null) {
                    if (!itFeatures.hasNext()) {
                        System.out.println("skipping the last rows");
                        break;
                    }
                    SimpleFeature feature = (SimpleFeature)itFeatures.next();
                    rowid = (String)feature.getAttribute("rowid");
                }
                if (!(row = itRow.next()).getKey().getString().equals(rowid)) continue;
                container.addRowToTable(row);
                rowid = null;
            }
        }
        finally {
            if (itRow != null) {
                itRow.close();
            }
            if (itFeatures != null) {
                itFeatures.close();
            }
            if (datastore != null) {
                datastore.dispose();
            }
        }
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void reset() {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_query.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_query.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_query.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

