/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.DataTableToGeotoolsMapper;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.IWarningWriter;
import java.util.Set;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;

public class DataTableToGeotoolsMapperForShapefile
extends DataTableToGeotoolsMapper {
    protected final Set<String> usedNames;
    private static final int MAX_LENGTH_NAME = 10;
    private static final int MAX_STRING_LENGTH = 254;

    public DataTableToGeotoolsMapperForShapefile(IWarningWriter warnWriter, DataColumnSpec knimeColSpec, Set<String> usedNames) {
        super(warnWriter, knimeColSpec);
        this.usedNames = usedNames;
    }

    public String getName() {
        String s;
        String res = s = this.colspec.getName();
        if (s.length() >= 10 || this.usedNames.contains(s)) {
            String temptative = s.substring(0, 10);
            int postfix = 0;
            int places = 1;
            while (this.usedNames.contains(temptative)) {
                temptative = String.valueOf(s.substring(0, 10 - places)) + postfix;
                if (++postfix == 10) {
                    places = 2;
                    continue;
                }
                if (postfix != 100) continue;
                places = 3;
            }
            res = temptative;
            this.usedNames.add(temptative);
        }
        if (!s.equals(res)) {
            this.warnWriter.warn("The column \"" + s + "\" will be shortened to \"" + res + "\" according to shapefile format limitations.");
        }
        return res;
    }

    public Object getValue(DataCell cell) {
        String s;
        Object res = super.getValue(cell);
        if (res != null && res instanceof String && (s = (String)res).length() > 254) {
            this.warnWriter.warn("due to shapefile limitations, truncating for column " + this.colspec.getName() + " the value " + s);
            return s.substring(0, 254);
        }
        return res;
    }

    public Object getValueNoNull(DataCell cell) {
        String s;
        Object res = super.getValueNoNull(cell);
        if (res != null && res instanceof String && (s = (String)res).length() > 254) {
            this.warnWriter.warn("due to shapefile limitations, truncating for column " + this.colspec.getName() + " the value " + s);
            return s.substring(0, 254);
        }
        return res;
    }
}

