/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.transform.centroid;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;

public class ComputeCentroidForWKTGeometriesNodeModel
extends NodeModel {
    long done = 0L;

    protected ComputeCentroidForWKTGeometriesNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec)) {
            throw new InvalidSettingsException("the input table contains no WKT geometry");
        }
        return new DataTableSpec[]{spec};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        if (!ReferencingFactoryFinder.getAuthorityNames().contains("AUTO")) {
            throw new RuntimeException("No factory for autority AUTO");
        }
        BufferedDataTable inputTable = inData[0];
        DataTableSpec outputSpec = inputTable.getDataTableSpec();
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        double total = inputTable.size();
        int numberOfCells = inputTable.getDataTableSpec().getNumColumns();
        int idxGeomCol = inputTable.getDataTableSpec().findColumnIndex("the_geom");
        WKTWriter writer = new WKTWriter();
        this.done = 0L;
        SpatialUtils.applyToEachGeometry((BufferedDataTable)inputTable, geomAndRow -> {
            DataCell[] cells = new DataCell[numberOfCells];
            int i = 0;
            while (i < numberOfCells) {
                cells[i] = i == idxGeomCol ? StringCell.StringCellFactory.create((String)writer.write((Geometry)geomAndRow.geometry.getCentroid())) : geomAndRow.row.getCell(i);
                ++i;
            }
            DefaultRow row = new DefaultRow(geomAndRow.row.getKey(), cells);
            container.addRowToTable((DataRow)row);
            if (this.done++ % 100L == 0L) {
                exec.checkCanceled();
                exec.setProgress((double)this.done / total, "computing centroid of row " + this.done);
            }
        });
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

