/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnProperties;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.NodeLogger;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * Exception performing whole class analysis ignored.
 */
public class FeaturesDecodingUtils {
    public static DataColumnSpec createDataColumnSpecForGeom(CoordinateReferenceSystem crs) {
        DataColumnSpecCreator creatorGeom = new DataColumnSpecCreator("the_geom", StringCell.TYPE);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crs));
        properties.put("crs WKT", crs.toWKT());
        DataColumnProperties propertiesKWT = new DataColumnProperties(properties);
        creatorGeom.setProperties(propertiesKWT);
        return creatorGeom.createSpec();
    }

    public static DataTableSpec createDataTableSpec(SimpleFeature f, NodeLogger logger, CoordinateReferenceSystem crs) {
        ArrayList<DataColumnSpec> specs = new ArrayList<DataColumnSpec>(f.getProperties().size() + 2);
        specs.add(FeaturesDecodingUtils.createDataColumnSpecForGeom((CoordinateReferenceSystem)crs));
        HashSet<String> foundNames = new HashSet<String>();
        for (Property property : f.getProperties()) {
            String name = property.getName().toString();
            if ("the_geom".equals(name) || "Feature".equals(name) || "LookAt".equals(name) || "Style".equals(name) || "Region".equals(name)) continue;
            if (!foundNames.add(name)) {
                int i = 1;
                while (foundNames.contains(String.valueOf(name) + "(" + ++i + ")")) {
                }
                logger.warn((Object)("there was already a property named \"" + name + "; we will rename this one " + name + "(" + i + ")"));
                name = String.valueOf(name) + "(" + i + ")";
            }
            specs.add(FeaturesDecodingUtils.getColumnSpecForFeatureProperty((Property)property, (String)name, (NodeLogger)logger));
        }
        return new DataTableSpec("KML entities", specs.toArray(new DataColumnSpec[specs.size()]));
    }

    public static DataColumnSpec getColumnSpecForFeatureProperty(Property property, String givenName, NodeLogger logger) {
        String name = property.getName().toString();
        Class type = property.getType().getBinding();
        DataType knimeType = null;
        if (Integer.class.isAssignableFrom(type)) {
            knimeType = IntCell.TYPE;
        } else if (String.class.isAssignableFrom(type)) {
            knimeType = StringCell.TYPE;
        } else if (Long.class.isAssignableFrom(type)) {
            knimeType = LongCell.TYPE;
        } else if (Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            knimeType = DoubleCell.TYPE;
        } else if (Boolean.class.isAssignableFrom(type)) {
            knimeType = BooleanCell.TYPE;
        } else {
            logger.warn((Object)("The type of KML property " + name + " is not supported (" + property.getType() + "); we will convert it to String"));
            knimeType = StringCell.TYPE;
        }
        return new DataColumnSpecCreator(givenName, knimeType).createSpec();
    }

    public static DataCell getDataCellForProperty(Property property, SimpleFeature feature) {
        String name = property.getName().toString();
        Class type = property.getType().getBinding();
        Object value = feature.getProperty(name).getValue();
        DataCell resultCell = null;
        resultCell = value == null ? null : (Integer.class.isAssignableFrom(type) ? IntCell.IntCellFactory.create((String)value.toString()) : (String.class.isAssignableFrom(type) ? StringCell.StringCellFactory.create((String)value.toString()) : (Long.class.isAssignableFrom(type) ? LongCell.LongCellFactory.create((String)value.toString()) : (Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) ? DoubleCell.DoubleCellFactory.create((String)value.toString()) : (Boolean.class.isAssignableFrom(type) ? BooleanCell.BooleanCellFactory.create((String)value.toString()) : StringCell.StringCellFactory.create((String)value.toString()))))));
        return resultCell;
    }
}

