/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.write.write_to_shapefile;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.DataTableToGeotoolsMapper;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.DataTableToGeotoolsMapperForShapefile;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.IWarningWriter;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.NodeWarningWriter;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.data.DataStore;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.util.FileUtil;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WriteWKTAsShapefileNodeModel
extends NodeModel {
    static final int BUFFER = 5000;
    static final int MAX_COLUMNS = 255;
    private final SettingsModelString m_file = new SettingsModelString("filename", null);

    protected WriteWKTAsShapefileNodeModel() {
        super(1, 0);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        URL url;
        BufferedDataTable inputPopulation = inData[0];
        if (!SpatialUtils.hasGeometry((DataTableSpec)inputPopulation.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)inputPopulation.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table contains spatial data but no Coordinate Reference System");
        }
        CoordinateReferenceSystem crsOrig = SpatialUtils.decodeCRS((DataTableSpec)inputPopulation.getSpec());
        try {
            url = FileUtil.toURL((String)this.m_file.getStringValue());
        }
        catch (MalformedURLException | InvalidPathException e2) {
            e2.printStackTrace();
            throw new InvalidSettingsException("unable to open URL " + this.m_file.getStringValue() + ": " + e2.getMessage());
        }
        File file = FileUtil.getFileFromURL((URL)url);
        NodeWarningWriter warnings = new NodeWarningWriter(this.getLogger());
        exec.setMessage("storing entities");
        DataStore datastore = SpatialUtils.createDataStore((File)file, (boolean)true);
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("entities");
        builder.setCRS(crsOrig);
        Class geomClassToBeStored = SpatialUtils.detectGeometryClassFromData((BufferedDataTable)inputPopulation, (String)"the_geom");
        builder.add("the_geom", geomClassToBeStored);
        if (inputPopulation.getDataTableSpec().getNumColumns() > 256) {
            int count = inputPopulation.getDataTableSpec().getNumColumns() - 255 - 1;
            warnings.warn("Only 255 columns can be stored in a shapefile format; will ignore the " + count + " last one(s)");
        }
        HashSet usedNames = new HashSet();
        List<DataTableToGeotoolsMapper> mappers = inputPopulation.getDataTableSpec().stream().filter(colspec -> !"the_geom".equals(colspec.getName())).limit(255L).map(colspec -> new DataTableToGeotoolsMapperForShapefile((IWarningWriter)warnings, colspec, usedNames)).collect(Collectors.toList());
        mappers.forEach(mapper -> mapper.addAttributeForSpec(builder));
        SimpleFeatureType type = builder.buildFeatureType();
        try {
            datastore.getSchema(type.getName());
        }
        catch (IOException e) {
            datastore.createSchema((FeatureType)type);
        }
        SimpleFeatureSource featureSource = datastore.getFeatureSource((Name)datastore.getNames().get(0));
        if (!(featureSource instanceof SimpleFeatureStore)) {
            throw new IllegalStateException("Modification not supported");
        }
        SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
        int idxColGeom = inputPopulation.getDataTableSpec().findColumnIndex("the_geom");
        GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
        WKTReader reader = new WKTReader(geomFactory);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
        ArrayList<SimpleFeature> toStore = new ArrayList<SimpleFeature>(5000);
        CloseableRowIterator itRow = inputPopulation.iterator();
        try {
            int currentRow = 0;
            while (itRow.hasNext()) {
                DataRow row = itRow.next();
                DataCell cellGeom = row.getCell(idxColGeom);
                if (cellGeom.isMissing()) continue;
                try {
                    Geometry geom = reader.read(cellGeom.toString());
                    featureBuilder.add((Object)geom);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                int colId = 0;
                int i = 0;
                while (i < row.getNumCells() && colId < mappers.size()) {
                    if (i != idxColGeom) {
                        featureBuilder.add(((DataTableToGeotoolsMapper)mappers.get(colId++)).getValue(row.getCell(i)));
                    }
                    ++i;
                }
                SimpleFeature feature = featureBuilder.buildFeature(row.getKey().getString());
                toStore.add(feature);
                if (toStore.size() >= 5000) {
                    exec.checkCanceled();
                    featureStore.addFeatures((FeatureCollection)new ListFeatureCollection(type, toStore));
                    toStore.clear();
                }
                if (currentRow % 10 == 0) {
                    exec.setProgress((double)currentRow / (double)inputPopulation.size(), "processing row " + currentRow);
                    exec.checkCanceled();
                }
                ++currentRow;
            }
            if (!toStore.isEmpty()) {
                featureStore.addFeatures((FeatureCollection)new ListFeatureCollection(type, toStore));
            }
            exec.setProgress(1.0);
        }
        finally {
            if (itRow != null) {
                itRow.close();
            }
            datastore.dispose();
        }
        this.setWarningMessage(warnings.buildWarnings());
        return new BufferedDataTable[0];
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec specs = inSpecs[0];
        if (this.m_file.getStringValue() == null) {
            throw new IllegalArgumentException("No filename was provided");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)specs)) {
            throw new IllegalArgumentException("the input table contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)specs)) {
            throw new IllegalArgumentException("the input table contains spatial data but no Coordinate Reference System");
        }
        try {
            FileUtil.toURL((String)this.m_file.getStringValue());
        }
        catch (MalformedURLException | InvalidPathException e2) {
            e2.printStackTrace();
            throw new InvalidSettingsException("unable to open URL " + this.m_file.getStringValue() + ": " + e2.getMessage());
        }
        return new DataTableSpec[0];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_file.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

