/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_shapefile;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.AbstractReadWKTFromDatastoreNodeModel;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_shapefile.GeotoolsToDataTableMapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.util.CheckUtils;
import org.knime.core.util.FileUtil;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ReadShapefileAsWKTNodeModel
extends AbstractReadWKTFromDatastoreNodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(ReadShapefileAsWKTNodeModel.class);
    private final SettingsModelString m_file = new SettingsModelString("filename", null);
    private final SettingsModelString m_charset = new SettingsModelString("charset", Charset.defaultCharset().name());

    protected ReadShapefileAsWKTNodeModel() {
    }

    protected DataStore openDataStore(PortObject[] inObjects, ExecutionContext exec) throws InvalidSettingsException {
        DataStore datastore;
        URL filename;
        CheckUtils.checkSourceFile((String)this.m_file.getStringValue());
        if (this.m_file.getStringValue() == null) {
            throw new InvalidSettingsException("no file defined");
        }
        try {
            filename = FileUtil.toURL((String)this.m_file.getStringValue());
        }
        catch (MalformedURLException | InvalidPathException e2) {
            e2.printStackTrace();
            throw new InvalidSettingsException("unable to open URL " + this.m_file.getStringValue() + ": " + e2.getMessage());
        }
        Path filePath = null;
        try {
            filePath = FileUtil.resolveToPath((URL)filename);
        }
        catch (IOException | URISyntaxException e2) {
            throw new InvalidSettingsException("unable to resolve this URL to a path: " + filename);
        }
        String charset = this.m_charset.getStringValue();
        HashMap<String, URL> parameters = new HashMap<String, URL>();
        try {
            parameters.put("url", filePath.toUri().toURL());
        }
        catch (MalformedURLException e2) {
            throw new RuntimeException("cannot convert the path " + filePath + " to an URL", e2);
        }
        try {
            this.getLogger().info((Object)("opening as a shapefile: " + filePath.toUri()));
            datastore = DataStoreFinder.getDataStore(parameters);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new InvalidSettingsException("Unable to open the url as a shape file: " + e1.getMessage());
        }
        if (datastore == null) {
            throw new InvalidSettingsException("unable to open the shapefile from path " + filename);
        }
        try {
            ((ShapefileDataStore)datastore).setCharset(Charset.forName(charset));
        }
        catch (ClassCastException e) {
            throw new InvalidSettingsException("unable to define charset for this datastore");
        }
        return datastore;
    }

    protected String getSchemaName(DataStore datastore) throws InvalidSettingsException {
        String schemaName = null;
        Object[] existing = null;
        try {
            existing = datastore.getTypeNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error while searching for a schema inside the shapefile: " + e, e);
        }
        if (existing.length > 1) {
            this.getLogger().warn((Object)("there are several layers in this data store: " + Arrays.toString(existing) + "; will open the first one: " + schemaName));
        }
        schemaName = existing[0];
        return schemaName;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        SimpleFeatureType type;
        String schemaName;
        DataStore datastore = this.openDataStore(null, null);
        try {
            schemaName = datastore.getTypeNames()[0];
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error while searching for a schema inside the shapefile: " + e, e);
        }
        try {
            type = datastore.getSchema(schemaName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to decode the schema " + schemaName + " from the file: " + e, e);
        }
        ArrayList descriptors = new ArrayList(type.getAttributeDescriptors());
        Map<AttributeDescriptor, GeotoolsToDataTableMapper> gtAttribute2mapper = descriptors.stream().collect(Collectors.toMap(ad -> ad, ad -> new GeotoolsToDataTableMapper(ad, type.getCoordinateReferenceSystem(), logger)));
        DataColumnSpec[] dataColSpecs = (DataColumnSpec[])descriptors.stream().map(d -> ((GeotoolsToDataTableMapper)gtAttribute2mapper.get(d)).getKnimeColumnSpec()).toArray(DataColumnSpec[]::new);
        DataTableSpec outputSpec = new DataTableSpec(dataColSpecs);
        return new DataTableSpec[]{outputSpec};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_file.saveSettingsTo(settings);
        this.m_charset.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.loadSettingsFrom(settings);
        this.m_charset.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.validateSettings(settings);
        this.m_charset.validateSettings(settings);
    }
}

