/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.transform.compute_ecql;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.jts.GeometryBuilder;
import org.knime.base.util.flowvariable.FlowVariableProvider;
import org.knime.base.util.flowvariable.FlowVariableResolver;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.DataType;
import org.knime.core.data.MissingCell;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.LongCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ComputeECQLNodeModel
extends NodeModel
implements FlowVariableProvider {
    private SettingsModelString m_query = new SettingsModelString("query", "area(the_geom)");
    private SettingsModelString m_type = new SettingsModelString("type", "Double");
    private SettingsModelString m_colname = new SettingsModelString("colname", "surface");
    private SettingsModelBoolean m_createGeometriesMulti = new SettingsModelBoolean("multigeom", true);
    protected GeometryBuilder geometryBuilder = null;

    protected ComputeECQLNodeModel() {
        super(1, 1);
    }

    protected DataColumnSpec createColumnSpec() throws InvalidSettingsException {
        String typeName = this.m_type.getStringValue().toLowerCase();
        DataType type = null;
        if (typeName.equalsIgnoreCase("string")) {
            type = StringCell.TYPE;
        } else if (typeName.equalsIgnoreCase("double")) {
            type = DoubleCell.TYPE;
        } else if (typeName.equalsIgnoreCase("integer")) {
            type = IntCell.TYPE;
        } else if (typeName.equalsIgnoreCase("long")) {
            type = LongCell.TYPE;
        } else if (typeName.equalsIgnoreCase("boolean")) {
            type = BooleanCell.TYPE;
        } else if (typeName.equalsIgnoreCase("geometry")) {
            type = null;
        } else {
            throw new InvalidSettingsException("unknown type " + typeName);
        }
        if (type == null) {
            return null;
        }
        String colname = this.m_colname.getStringValue();
        return new DataColumnSpecCreator(colname, type).createSpec();
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec)) {
            throw new InvalidSettingsException("the input table does not contains WKT spatial data");
        }
        this.getExpression();
        String typeName = this.m_type.getStringValue().toLowerCase();
        String colname = this.m_colname.getStringValue();
        if (spec.getColumnSpec(colname) != null && !typeName.equalsIgnoreCase("geometry")) {
            throw new InvalidSettingsException("There is already a column named " + colname + " in the input table");
        }
        DataColumnSpec addedColumn = this.createColumnSpec();
        DataTableSpecCreator specCreateor = new DataTableSpecCreator(spec);
        if (addedColumn != null) {
            specCreateor.addColumns(new DataColumnSpec[]{addedColumn});
        }
        return new DataTableSpec[]{specCreateor.createSpec()};
    }

    protected Expression getExpression() throws InvalidSettingsException {
        String query = this.m_query.getStringValue();
        String queryWithVariableValues = FlowVariableResolver.parse((String)query, (FlowVariableProvider)this);
        Expression exp = null;
        try {
            exp = ECQL.toExpression((String)queryWithVariableValues);
        }
        catch (CQLException e) {
            throw new InvalidSettingsException("invalid CQL expression: " + e.getMessage(), (Throwable)e);
        }
        return exp;
    }

    protected Geometry createMultiGeometry(Object o) {
        if (Polygon.class.isAssignableFrom(o.getClass())) {
            return this.geometryBuilder.multiPolygon(new Polygon[]{(Polygon)o});
        }
        if (LineString.class.isAssignableFrom(o.getClass())) {
            return this.geometryBuilder.multiLineString(new LineString[]{(LineString)o});
        }
        return (Geometry)o;
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        boolean createMultiGeom = this.m_createGeometriesMulti.getBooleanValue();
        String typename = this.m_type.getStringValue();
        boolean typeIsGeom = typename.equals("Geometry");
        BufferedDataTable inputPopulation = inData[0];
        DataColumnSpec addedColumn = this.createColumnSpec();
        DataTableSpecCreator specCreateor = new DataTableSpecCreator(inputPopulation.getDataTableSpec());
        if (addedColumn != null) {
            specCreateor.addColumns(new DataColumnSpec[]{addedColumn});
        }
        DataTableSpec newSpec = specCreateor.createSpec();
        Expression exp = this.getExpression();
        DataStore datastore = SpatialUtils.createTmpDataStore((boolean)false);
        ExecutionContext execSpatialize = exec.createSubExecutionContext(0.5);
        ExecutionContext execFilter = exec.createSubExecutionContext(0.5);
        CoordinateReferenceSystem crs = SpatialUtils.decodeCRS((DataTableSpec)inputPopulation.getDataTableSpec());
        exec.setMessage("spatializing features");
        SpatialUtils.decodeAsFeatures((BufferedDataTable)inputPopulation, (String)"the_geom", (ExecutionMonitor)execSpatialize, (DataStore)datastore, (String)"entities", (CoordinateReferenceSystem)crs);
        this.geometryBuilder = new GeometryBuilder();
        exec.setMessage("computing " + this.m_colname.getStringValue());
        SimpleFeatureCollection features = datastore.getFeatureSource((Name)datastore.getNames().get(0)).getFeatures();
        BufferedDataContainer container = exec.createDataContainer(newSpec);
        CloseableRowIterator itRow = inputPopulation.iterator();
        MissingCell missing = new MissingCell("no data");
        int idxGeom = newSpec.findColumnIndex("the_geom");
        SimpleFeatureIterator itFeatures = features.features();
        double total = inputPopulation.size();
        int done = 0;
        try {
            while (itRow.hasNext()) {
                if (!itFeatures.hasNext()) {
                    throw new RuntimeException("error during the spatialization: less features than lines. This should not happen and reveals a problem in the program.");
                }
                SimpleFeature feature = (SimpleFeature)itFeatures.next();
                DataRow row = itRow.next();
                if (done++ % 10 == 0) {
                    exec.checkCanceled();
                    execFilter.setProgress((double)done / total);
                }
                String rowid = (String)feature.getAttribute("rowid");
                if (!row.getKey().getString().equals(rowid)) {
                    throw new RuntimeException("The features were not returned in the right order. please report a bug...");
                }
                ArrayList<Object> cells = null;
                Object res = exp.evaluate((Object)feature);
                if (createMultiGeom && typeIsGeom) {
                    res = this.createMultiGeometry(res);
                }
                if (addedColumn == null) {
                    cells = new ArrayList<Object>(row.getNumCells());
                    int col = 0;
                    while (col < idxGeom) {
                        cells.add(row.getCell(col));
                        ++col;
                    }
                    cells.add(StringCell.StringCellFactory.create((String)res.toString()));
                    col = idxGeom + 1;
                    while (col < row.getNumCells()) {
                        cells.add(row.getCell(col));
                        ++col;
                    }
                } else {
                    MissingCell newCell;
                    block24: {
                        newCell = null;
                        try {
                            if (res == null) {
                                newCell = missing;
                                break block24;
                            }
                            if (addedColumn.getType().equals((Object)StringCell.TYPE)) {
                                newCell = StringCell.StringCellFactory.create((String)res.toString());
                                break block24;
                            }
                            if (addedColumn.getType().equals((Object)IntCell.TYPE)) {
                                newCell = IntCell.IntCellFactory.create((int)((Number)res).intValue());
                                break block24;
                            }
                            if (addedColumn.getType().equals((Object)DoubleCell.TYPE)) {
                                newCell = DoubleCell.DoubleCellFactory.create((double)((Number)res).doubleValue());
                                break block24;
                            }
                            if (addedColumn.getType().equals((Object)LongCell.TYPE)) {
                                newCell = LongCell.LongCellFactory.create((long)((Number)res).longValue());
                                break block24;
                            }
                            if (addedColumn.getType().equals((Object)BooleanCell.TYPE)) {
                                newCell = BooleanCell.BooleanCellFactory.create((boolean)((Boolean)res));
                                break block24;
                            }
                            throw new RuntimeException("unknown type " + addedColumn.getType());
                        }
                        catch (ClassCastException e) {
                            throw new InvalidSettingsException("the type you selected is not compliant with the result of the expression; try " + res.getClass().getSimpleName());
                        }
                    }
                    cells = new ArrayList(row.getNumCells() + 1);
                    cells.addAll(row.stream().collect(Collectors.toList()));
                    cells.add(newCell);
                }
                container.addRowToTable((DataRow)new DefaultRow(row.getKey(), cells));
            }
        }
        finally {
            if (itRow != null) {
                itRow.close();
            }
            if (itFeatures != null) {
                itFeatures.close();
            }
            if (datastore != null) {
                datastore.dispose();
            }
        }
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void reset() {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_query.saveSettingsTo(settings);
        this.m_type.saveSettingsTo(settings);
        this.m_colname.saveSettingsTo(settings);
        this.m_createGeometriesMulti.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_query.loadSettingsFrom(settings);
        this.m_type.loadSettingsFrom(settings);
        this.m_colname.loadSettingsFrom(settings);
        this.m_createGeometriesMulti.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_query.validateSettings(settings);
        this.m_type.validateSettings(settings);
        this.m_colname.validateSettings(settings);
        this.m_createGeometriesMulti.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

