/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.create.geocoding.osm;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.create.geocoding.osm.OSMGeocodingCache;
import fr.dudie.nominatim.client.JsonNominatimClient;
import fr.dudie.nominatim.client.request.NominatimSearchRequest;
import fr.dudie.nominatim.client.request.paramhelper.PolygonFormat;
import fr.dudie.nominatim.model.Address;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnProperties;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.MissingCell;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeocodingOSMNodeModel
extends NodeModel {
    private final SettingsModelString m_colname_address = new SettingsModelString("colname_address", "address");
    private final SettingsModelString m_url = new SettingsModelString("url", "https://nominatim.openstreetmap.org/");
    private final SettingsModelString m_email = new SettingsModelString("email", "");
    private final SettingsModelBoolean m_geom = new SettingsModelBoolean("full geometries", Boolean.FALSE.booleanValue());

    protected GeocodingOSMNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec;
        String email = this.m_email.getStringValue();
        if (email == null || email.trim().isEmpty()) {
            this.setWarningMessage("please provide an email to comply with the terms of service");
        }
        if ((spec = inSpecs[0]) == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (spec.containsName("the_geom")) {
            throw new InvalidSettingsException("the input table already contains a column named the_geom");
        }
        if (!spec.containsName(this.m_colname_address.getStringValue())) {
            throw new InvalidSettingsException("unknown column " + this.m_colname_address.getStringValue() + " in the table");
        }
        return new DataTableSpec[]{this.createOutputSpec(spec)};
    }

    private DataTableSpec createOutputSpec(DataTableSpec inputTableSpec) {
        CoordinateReferenceSystem crsTarget = SpatialUtils.getCRSforString((String)"epsg:4326");
        ArrayList<DataColumnSpec> newColumnSpecs = new ArrayList<DataColumnSpec>(inputTableSpec.getNumColumns() + 5);
        int i = 0;
        while (i < inputTableSpec.getNumColumns()) {
            newColumnSpecs.add(inputTableSpec.getColumnSpec(i));
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>(inputTableSpec.getProperties());
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crsTarget));
        properties.put("crs WKT", crsTarget.toWKT());
        DataColumnSpecCreator creator = new DataColumnSpecCreator("the_geom", StringCell.TYPE);
        creator.setProperties(new DataColumnProperties(properties));
        newColumnSpecs.add(creator.createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("type", StringCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("osm id", StringCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("osm type", StringCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("licence", StringCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("rank", IntCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("rank interpretation", StringCell.TYPE).createSpec());
        return new DataTableSpec(newColumnSpecs.toArray(new DataColumnSpec[newColumnSpecs.size()]));
    }

    public static String getRankInterpretation(int rank) {
        if (rank <= 2) {
            return "Continent, sea";
        }
        if (rank <= 4) {
            return "Country";
        }
        if (rank <= 8) {
            return "State";
        }
        if (rank <= 10) {
            return "Region";
        }
        if (rank <= 12) {
            return "County";
        }
        if (rank <= 16) {
            return "City";
        }
        if (rank <= 17) {
            return "Island, town, moor, waterways\t";
        }
        if (rank <= 18) {
            return "Village, hamlet, municipality, district, borough, airport, national park\t";
        }
        if (rank <= 20) {
            return "Suburb, croft, subdivision, farm, locality, islet\t";
        }
        if (rank <= 22) {
            return "Hall of residence, neighbourhood, housing estate, landuse (polygon only)\t";
        }
        if (rank <= 26) {
            return "Airport, street, road\t";
        }
        if (rank <= 27) {
            return "Paths, cycleways, service roads, etc.";
        }
        if (rank <= 28) {
            return "House, building";
        }
        return "Other";
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inputTable = inData[0];
        String colname = this.m_colname_address.getStringValue();
        Boolean fullGeom = this.m_geom.getBooleanValue();
        DataTableSpec outputSpec = this.createOutputSpec(inputTable.getDataTableSpec());
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        GeometryFactory gf = new GeometryFactory();
        int idxColAddress = inputTable.getSpec().findColumnIndex(colname);
        int countMultipleResults = 0;
        CloseableRowIterator itRow = inputTable.iterator();
        long done = 0L;
        double total = inputTable.size();
        if (inputTable.size() > 100L && this.m_email.getStringValue().trim().isEmpty()) {
            this.setWarningMessage("you ask for the geocoding of many addresses; please provide a valid email so the managers of the service can contact you if this usage creates issues");
        }
        MissingCell missing = new MissingCell("no location found");
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        SingleClientConnManager connexionManager = new SingleClientConnManager(null, registry);
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connexionManager, null);
        String baseUrl = this.m_url.getStringValue();
        String email = this.m_email.getStringValue();
        JsonNominatimClient nominatimClient = new JsonNominatimClient(baseUrl, (HttpClient)httpClient, email);
        long timestampLastQuery = 0L;
        while (itRow.hasNext()) {
            DataRow row = itRow.next();
            String address = ((StringValue)row.getCell(idxColAddress)).getStringValue();
            exec.checkCanceled();
            exec.setProgress((double)done++ / total, "geocoding " + address);
            List addresses = (List)OSMGeocodingCache.getInstance().getOSMGeocodingForAddress(address);
            if (addresses == null) {
                NominatimSearchRequest r = new NominatimSearchRequest();
                r.setQuery(address);
                r.setPolygonFormat(PolygonFormat.GEO_JSON);
                exec.setMessage("(wait) geocoding " + address);
                while (System.currentTimeMillis() - timestampLastQuery < 1000L) {
                    Thread.sleep(100L);
                    exec.checkCanceled();
                }
                exec.setMessage("geocoding " + address);
                try {
                    addresses = nominatimClient.search(r);
                    timestampLastQuery = System.currentTimeMillis();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw new RuntimeException("error while geocoding: " + e.getLocalizedMessage());
                }
                if (addresses != null) {
                    OSMGeocodingCache.getInstance().storeInCache(address, (Object)addresses);
                }
                exec.checkCanceled();
            }
            if (addresses == null || addresses.isEmpty()) {
                this.getLogger().warn((Object)("unable to find a location for address " + address));
                ArrayList<Object> cells = new ArrayList<Object>(outputSpec.getNumColumns());
                int i = 0;
                while (i < row.getNumCells()) {
                    cells.add(row.getCell(i));
                    ++i;
                }
                i = 0;
                while (i < 7) {
                    cells.add(missing);
                    ++i;
                }
                container.addRowToTable((DataRow)new DefaultRow(row.getKey(), cells));
                continue;
            }
            if (addresses.size() > 1) {
                if (++countMultipleResults == 1) {
                    this.setWarningMessage("One address led to multiple locations; one row is created for each location, group the results by address to get only the first result");
                } else {
                    this.setWarningMessage(String.valueOf(countMultipleResults) + " addresses led to multiple locations; one row is created for each location, group the results by address to get only the first result");
                }
            }
            int currentResult = 1;
            for (Address addr : addresses) {
                ArrayList<DataCell> cells = new ArrayList<DataCell>(outputSpec.getNumColumns());
                int i = 0;
                while (i < row.getNumCells()) {
                    cells.add(row.getCell(i));
                    ++i;
                }
                double latitude = addr.getLatitude();
                double longitude = addr.getLongitude();
                Point point = gf.createPoint(new Coordinate(longitude, latitude));
                if (fullGeom.booleanValue() && addr.getGeojson() != null) {
                    cells.add(StringCell.StringCellFactory.create((String)addr.getGeojson().toString()));
                } else {
                    cells.add(StringCell.StringCellFactory.create((String)point.toString()));
                }
                cells.add(StringCell.StringCellFactory.create((String)addr.getElementType()));
                cells.add(StringCell.StringCellFactory.create((String)addr.getOsmId()));
                cells.add(StringCell.StringCellFactory.create((String)addr.getOsmType()));
                cells.add(StringCell.StringCellFactory.create((String)addr.getLicence()));
                cells.add(IntCell.IntCellFactory.create((int)addr.getPlaceRank()));
                cells.add(StringCell.StringCellFactory.create((String)GeocodingOSMNodeModel.getRankInterpretation((int)addr.getPlaceRank())));
                if (addresses.size() == 1) {
                    container.addRowToTable((DataRow)new DefaultRow(row.getKey(), cells));
                    continue;
                }
                container.addRowToTable((DataRow)new DefaultRow(new RowKey(String.valueOf(row.getKey().getString()) + "_" + currentResult++), cells));
            }
        }
        itRow.close();
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_colname_address.saveSettingsTo(settings);
        this.m_email.saveSettingsTo(settings);
        this.m_geom.saveSettingsTo(settings);
        this.m_url.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname_address.loadSettingsFrom(settings);
        this.m_email.loadSettingsFrom(settings);
        this.m_geom.loadSettingsFrom(settings);
        this.m_url.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname_address.validateSettings(settings);
        this.m_email.validateSettings(settings);
        this.m_geom.validateSettings(settings);
        this.m_url.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

