/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.properties.type;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class TypeOfWKTGeometriesNodeModel
extends NodeModel {
    SettingsModelString m_colname = new SettingsModelString("colname", "geom_type");
    long done = 0L;

    protected TypeOfWKTGeometriesNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec createSpec(DataTableSpec inSpec) {
        DataTableSpecCreator creator = new DataTableSpecCreator(inSpec);
        creator.addColumns(new DataColumnSpec[]{new DataColumnSpecCreator(this.m_colname.getStringValue(), StringCell.TYPE).createSpec()});
        return creator.createSpec();
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec)) {
            throw new InvalidSettingsException("the input table contains no WKT geometry");
        }
        if (spec.containsName(this.m_colname.getStringValue())) {
            throw new InvalidSettingsException("the input table already contains a column named " + this.m_colname.getStringValue());
        }
        return new DataTableSpec[]{this.createSpec(spec)};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        if (!ReferencingFactoryFinder.getAuthorityNames().contains("AUTO")) {
            throw new RuntimeException("No factory for autority AUTO");
        }
        BufferedDataTable inputTable = inData[0];
        DataTableSpec outputSpec = this.createSpec(inputTable.getDataTableSpec());
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        double total = inputTable.size();
        int numberOfCells = inputTable.getDataTableSpec().getNumColumns();
        this.done = 0L;
        SpatialUtils.applyToEachGeometry((BufferedDataTable)inputTable, geomAndRow -> {
            ArrayList<DataCell> cells = new ArrayList<DataCell>(numberOfCells + 1);
            cells.addAll(geomAndRow.row.stream().collect(Collectors.toList()));
            cells.add(StringCell.StringCellFactory.create((String)geomAndRow.geometry.getClass().getSimpleName()));
            DefaultRow row = new DefaultRow(geomAndRow.row.getKey(), cells);
            container.addRowToTable((DataRow)row);
            if (this.done++ % 10L == 0L) {
                exec.checkCanceled();
                exec.setProgress((double)this.done / total, "computing row " + this.done);
            }
        });
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_colname.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

