/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.ShapefileAsWKTNodePlugin;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Random;
import org.geotools.data.DataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.util.FileUtil;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Within;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpatialUtils {
    public static final String GEOMETRY_COLUMN_NAME = "the_geom";
    public static final String PROPERTY_CRS_CODE = "crs code";
    public static final String PROPERTY_CRS_WKT = "crs WKT";
    public static final String ATTRIBUTE_NAME_INCREMENTAL_ID = "inc_id";

    public static String getDefaultCRSString() {
        return "EPSG:4326";
    }

    public static String getStringForCRS(CoordinateReferenceSystem crs) {
        try {
            ReferenceIdentifier id = (ReferenceIdentifier)crs.getIdentifiers().iterator().next();
            return String.valueOf(id.getCodeSpace()) + ":" + id.getCode();
        }
        catch (NoSuchElementException e) {
            return String.valueOf(crs.getName().getCodeSpace()) + ":" + crs.getName().getCode();
        }
    }

    public static CoordinateReferenceSystem getCRSforString(String s) {
        if (s == null || s.equalsIgnoreCase("null")) {
            throw new IllegalArgumentException("No CRS provided");
        }
        try {
            return CRS.decode((String)s);
        }
        catch (FactoryException e1) {
            e1.printStackTrace();
            throw new IllegalArgumentException("unable to decode CRS from string: " + s);
        }
        catch (NullPointerException e2) {
            throw new IllegalArgumentException("This string does not contains any CRS: " + s);
        }
        catch (RuntimeException e3) {
            e3.printStackTrace();
            throw new IllegalArgumentException("Error when decoding CRS from string " + s + ": " + e3.getMessage(), e3);
        }
    }

    public static Class<?> detectGeometryClassFromData(BufferedDataTable sample, String colNameGeom) throws IllegalArgumentException {
        int SAMPLE = 50;
        int idxColGeom = sample.getDataTableSpec().findColumnIndex(colNameGeom);
        GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
        WKTReader reader = new WKTReader(geomFactory);
        ArrayList<Geometry> foundGeometries = new ArrayList<Geometry>(50);
        for (DataRow currentRow : sample) {
            DataCell cellGeom = currentRow.getCell(idxColGeom);
            if (cellGeom.isMissing()) continue;
            try {
                Geometry g2 = reader.read(cellGeom.toString());
                foundGeometries.add(g2);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (foundGeometries.size() >= 50) break;
        }
        if (foundGeometries.isEmpty()) {
            throw new IllegalArgumentException("no geometry found in column " + colNameGeom);
        }
        Class<?> classFirst = ((Geometry)foundGeometries.get(0)).getClass();
        if (foundGeometries.stream().anyMatch(g -> !g.getClass().equals(classFirst))) {
            throw new IllegalArgumentException("not all the geometry types are the same");
        }
        return classFirst;
    }

    public static DataStore createDataStore() {
        return SpatialUtils.createTmpDataStore((boolean)true);
    }

    public static SimpleFeatureType createGeotoolsType(BufferedDataTable sample, String colNameGeom, String featureName, CoordinateReferenceSystem crs, boolean addIncrementalId, boolean addColor) throws IllegalArgumentException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(featureName);
        builder.setCRS(crs);
        Class geomClassToBeStored = SpatialUtils.detectGeometryClassFromData((BufferedDataTable)sample, (String)colNameGeom);
        builder.add("the_geom", geomClassToBeStored);
        builder.add("rowid", String.class);
        if (addColor) {
            builder.add("color", String.class);
        }
        if (addIncrementalId) {
            builder.add("inc_id", Integer.class);
        }
        SimpleFeatureType type = builder.buildFeatureType();
        return type;
    }

    public static SimpleFeatureStore createFeatureStore(BufferedDataTable sample, DataStore datastore, SimpleFeatureType type, String featureName) throws IOException {
        try {
            datastore.getSchema(type.getName());
        }
        catch (IOException e) {
            datastore.createSchema((FeatureType)type);
        }
        SimpleFeatureSource featureSource = datastore.getFeatureSource((Name)datastore.getNames().get(0));
        if (!(featureSource instanceof SimpleFeatureStore)) {
            throw new IllegalStateException("Modification not supported");
        }
        SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
        return featureStore;
    }

    public static void applyToEachGeometry(BufferedDataTable sample, IRowAndGeometryConsumer geometryConsumer) throws CanceledExecutionException, InvalidSettingsException {
        block7: {
            GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
            WKTReader reader = new WKTReader(geomFactory);
            int idxColGeom = sample.getDataTableSpec().findColumnIndex("the_geom");
            CloseableRowIterator itRow = sample.iterator();
            block5: while (true) {
                while (itRow.hasNext()) {
                    DataRow row = itRow.next();
                    DataCell cellGeom = row.getCell(idxColGeom);
                    if (cellGeom.isMissing()) continue;
                    try {
                        Geometry geom = reader.read(cellGeom.toString());
                        geometryConsumer.accept(new RowAndGeometry(geom, row));
                        continue block5;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        throw new IllegalArgumentException("Invalid WKT geometry on row " + row.getKey() + ":" + e.getMessage(), e);
                    }
                }
                break block7;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                itRow.close();
            }
        }
    }

    public static void applyToEachGeometry(BufferedDataTable sample1, BufferedDataTable sample2, IRowsAndGeometrysConsumer geometriesConsumer) throws CanceledExecutionException, InvalidSettingsException {
        if (sample1.size() != sample2.size()) {
            throw new InvalidSettingsException("the two input tables should have the same size");
        }
        GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
        WKTReader reader = new WKTReader(geomFactory);
        int idxColGeom1 = sample1.getDataTableSpec().findColumnIndex("the_geom");
        int idxColGeom2 = sample2.getDataTableSpec().findColumnIndex("the_geom");
        CloseableRowIterator itRow1 = sample1.iterator();
        CloseableRowIterator itRow2 = sample2.iterator();
        try {
            while (itRow1.hasNext()) {
                if (!itRow2.hasNext()) {
                    throw new RuntimeException("there are no more as many entities in the two tables o_O");
                }
                DataRow row1 = itRow1.next();
                DataCell cellGeom1 = row1.getCell(idxColGeom1);
                DataRow row2 = itRow2.next();
                DataCell cellGeom2 = row2.getCell(idxColGeom2);
                if (cellGeom1.isMissing() || cellGeom2.isMissing()) continue;
                Geometry geom1 = null;
                try {
                    geom1 = reader.read(cellGeom1.toString());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Invalid WKT geometry on row " + row1.getKey() + ":" + e.getMessage(), e);
                }
                Geometry geom2 = null;
                try {
                    geom2 = reader.read(cellGeom2.toString());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException("Invalid WKT geometry on row " + row2.getKey() + ":" + e.getMessage(), e);
                }
                geometriesConsumer.accept(new RowsAndGeometrys(geom1, row1, geom2, row2));
            }
        }
        finally {
            itRow1.close();
            itRow2.close();
        }
    }

    public static Runnable decodeAsFeaturesRunnable(BufferedDataTable sample, String colNameGeom, ExecutionMonitor execProgress, DataStore datastore, String featureName, CoordinateReferenceSystem crs, boolean addIncrementalId, Color defaultColor) throws IOException {
        SimpleFeatureType type = SpatialUtils.createGeotoolsType((BufferedDataTable)sample, (String)colNameGeom, (String)featureName, (CoordinateReferenceSystem)crs, (boolean)addIncrementalId, (defaultColor != null ? 1 : 0) != 0);
        SimpleFeatureStore store = SpatialUtils.createFeatureStore((BufferedDataTable)sample, (DataStore)datastore, (SimpleFeatureType)type, (String)featureName);
        int idxColGeom = sample.getDataTableSpec().findColumnIndex(colNameGeom);
        return new AddRowsRunnable(sample, idxColGeom, store, type, execProgress, addIncrementalId, defaultColor);
    }

    public static void decodeAsFeatures(BufferedDataTable sample, String colNameGeom, ExecutionMonitor execProgress, DataStore datastore, String featureName, CoordinateReferenceSystem crs) throws IOException {
        SimpleFeatureType type = SpatialUtils.createGeotoolsType((BufferedDataTable)sample, (String)colNameGeom, (String)featureName, (CoordinateReferenceSystem)crs, (boolean)false, (boolean)false);
        SimpleFeatureStore store = SpatialUtils.createFeatureStore((BufferedDataTable)sample, (DataStore)datastore, (SimpleFeatureType)type, (String)featureName);
        int idxColGeom = sample.getDataTableSpec().findColumnIndex(colNameGeom);
        AddRowsRunnable runnable = new AddRowsRunnable(sample, idxColGeom, store, type, execProgress, false, null);
        runnable.run();
    }

    public static DataStore createTmpDataStore(boolean createSpatialIndex) {
        File file;
        try {
            file = FileUtil.createTempFile((String)"datastore", (String)".shp", (boolean)true);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new RuntimeException("unable to create a geotools datastore", e1);
        }
        return SpatialUtils.createDataStore((File)file, (boolean)createSpatialIndex);
    }

    public static DataStore createDataStore(File file, boolean createSpatialIndex) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        try {
            map.put("url", file.toURI().toURL());
            map.put("create spatial index", Boolean.valueOf(createSpatialIndex));
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            throw new RuntimeException("unable to create a geotools datastore", e1);
        }
        DataStore dataStore = null;
        try {
            dataStore = new ShapefileDataStoreFactory().createNewDataStore(map);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("unable to create a geotools datastore", e);
        }
        return dataStore;
    }

    public static FeatureIterator<SimpleFeature> findEntitiesWithin(SimpleFeatureSource source, Geometry geom) {
        SimpleFeatureIterator fItt;
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
        Within filter = ff.within((Expression)ff.property("the_geom"), (Expression)ff.literal((Object)geom));
        try {
            fItt = source.getFeatures((Filter)filter).features();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error while loading entities", e);
        }
        return fItt;
    }

    public static FeatureIterator<SimpleFeature> findClosestNeighboorFixBuffer(Geometry geom, SimpleFeatureSource source, int buffer) {
        Geometry buffered = geom.buffer((double)buffer);
        return SpatialUtils.findEntitiesWithin((SimpleFeatureSource)source, (Geometry)buffered);
    }

    public static SimpleFeature findClosestNeighboorVariableBuffer(Geometry geom, SimpleFeatureSource source, int maxBuffer) {
        LinkedList<Integer> distances = new LinkedList<Integer>();
        distances.add(maxBuffer);
        int current = maxBuffer;
        while (current >= 100) {
            distances.add(0, current -= 20);
        }
        while (current >= 20) {
            distances.add(0, current -= 10);
        }
        double shortestDistance = Double.MAX_VALUE;
        LinkedList<SimpleFeature> closestPoints = new LinkedList<SimpleFeature>();
        for (Integer bufferDistance : distances) {
            FeatureIterator itNeighboors = SpatialUtils.findClosestNeighboorFixBuffer((Geometry)geom, (SimpleFeatureSource)source, (int)bufferDistance);
            while (itNeighboors.hasNext()) {
                SimpleFeature neighboor = (SimpleFeature)itNeighboors.next();
                double distance = geom.distance((Geometry)neighboor.getAttribute(0));
                if (distance < shortestDistance) {
                    shortestDistance = distance;
                    closestPoints.clear();
                    closestPoints.add(neighboor);
                    continue;
                }
                if (distance != shortestDistance) continue;
                closestPoints.add(neighboor);
            }
            itNeighboors.close();
            if (!closestPoints.isEmpty()) break;
        }
        if (closestPoints.size() == 1) {
            return (SimpleFeature)closestPoints.get(0);
        }
        if (closestPoints.size() > 1) {
            Random random = new Random();
            return (SimpleFeature)closestPoints.get(random.nextInt(closestPoints.size()));
        }
        return null;
    }

    private SpatialUtils() {
    }

    public static boolean hasCRS(DataColumnSpec columnSpec) {
        return columnSpec.getProperties().getProperty("crs code") != null;
    }

    public static CoordinateReferenceSystem decodeCRSFromColumnSpec(DataColumnSpec columnSpec) {
        try {
            return SpatialUtils.getCRSforString((String)columnSpec.getProperties().getProperty("crs code"));
        }
        catch (IllegalArgumentException e) {
            try {
                return CRS.parseWKT((String)columnSpec.getProperties().getProperty("crs WKT"));
            }
            catch (FactoryException e1) {
                e1.printStackTrace();
                throw new IllegalArgumentException("Unable to decode a coordinate reference system from the code \"" + columnSpec.getProperties().getProperty("crs code") + "\"" + " nor from WKT " + columnSpec.getProperties().getProperty("crs WKT"));
            }
        }
    }

    public static CoordinateReferenceSystem decodeCRS(DataTableSpec spec) {
        int idx = spec.findColumnIndex("the_geom");
        if (idx < 0) {
            throw new IllegalArgumentException("No column for containing geometry the_geom");
        }
        DataColumnSpec columnSpec = spec.getColumnSpec(idx);
        try {
            return SpatialUtils.getCRSforString((String)columnSpec.getProperties().getProperty("crs code"));
        }
        catch (IllegalArgumentException e) {
            try {
                return CRS.parseWKT((String)columnSpec.getProperties().getProperty("crs WKT"));
            }
            catch (FactoryException e1) {
                e1.printStackTrace();
                throw new IllegalArgumentException("Unable to decode a coordinate reference system from the code \"" + columnSpec.getProperties().getProperty("crs code") + "\"" + " nor from WKT " + columnSpec.getProperties().getProperty("crs WKT"));
            }
        }
    }

    public static boolean hasCRS(DataTableSpec dataTableSpec) {
        int idx = dataTableSpec.findColumnIndex("the_geom");
        if (idx < 0) {
            return false;
        }
        return dataTableSpec.getColumnSpec(idx).getProperties().getProperty("crs WKT") != null;
    }

    public static boolean hasGeometry(DataTableSpec dataTableSpec) {
        int idx = dataTableSpec.findColumnIndex("the_geom");
        return idx >= 0;
    }

    public static File getFileForCache() {
        String filepath = ShapefileAsWKTNodePlugin.getDefault().getPreferenceStore().getString("cacheDirectory");
        File f = new File(filepath);
        f.mkdirs();
        return f;
    }
}

