/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.transform.randompoint;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.MissingCell;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTWriter;

public class RandomPointInShapeNodeModel
extends NodeModel {
    private final SettingsModelBoolean m_autoseed = new SettingsModelBoolean("seed_auto", true);
    private final SettingsModelIntegerBounded m_seed = new SettingsModelIntegerBounded("seed", 55555, Integer.MIN_VALUE, Integer.MAX_VALUE);
    private final SettingsModelIntegerBounded m_count = new SettingsModelIntegerBounded("count", 1, 1, Integer.MAX_VALUE);
    long done = 0L;
    protected MersenneTwister random;
    protected Uniform uniform;
    protected GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();

    protected RandomPointInShapeNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec)) {
            throw new InvalidSettingsException("the input table contains no WKT geometry");
        }
        return new DataTableSpec[]{spec};
    }

    protected Point getRandomPointOnGeometry(Point point) {
        return point;
    }

    protected Point getRandomPointOnGeometry(Polygon polygon) {
        Envelope envelope = polygon.getEnvelopeInternal();
        double minx = envelope.getMinX();
        double miny = envelope.getMinY();
        double maxx = envelope.getMaxX();
        double maxy = envelope.getMaxY();
        Point point = null;
        int iterations = 0;
        do {
            if (iterations++ <= 5) continue;
            System.out.println("find random point: iteration " + iterations);
        } while (!(point = this.geometryFactory.createPoint(new Coordinate(this.uniform.nextDoubleFromTo(minx, maxx), this.uniform.nextDoubleFromTo(miny, maxy)))).within((Geometry)polygon));
        return point;
    }

    protected Point getRandomPointOnLine(LineString line) {
        double length = line.getLength();
        double randomDistance = this.uniform.nextDoubleFromTo(0.0, length);
        double cumulatedDistance = 0.0;
        Coordinate previousPoint = line.getStartPoint().getCoordinate();
        int i = 1;
        while (i < line.getNumPoints()) {
            Coordinate currentPoint = line.getCoordinateN(i);
            previousPoint = currentPoint;
            if ((cumulatedDistance += currentPoint.distance(previousPoint)) >= randomDistance) break;
            ++i;
        }
        Coordinate from = line.getCoordinateN(i - 1);
        Coordinate to = line.getCoordinateN(i);
        double prop = this.uniform.nextDoubleFromTo(0.0, 1.0);
        Coordinate c = new Coordinate(from.getX() + prop * (to.getX() - from.getX()), from.getY() + prop * (to.getY() - from.getY()));
        this.geometryFactory.getPrecisionModel().makePrecise(c);
        return this.geometryFactory.createPoint(c);
    }

    protected Point getRandomPointOnGeometry(MultiPolygon multipoly) {
        double totalArea = multipoly.getArea();
        double roulette = this.uniform.nextDoubleFromTo(0.0, totalArea);
        double cumulatedArea = 0.0;
        int i = 0;
        while (i < multipoly.getNumGeometries()) {
            if ((cumulatedArea += multipoly.getGeometryN(i).getArea()) >= roulette) break;
            ++i;
        }
        Polygon polygon = (Polygon)multipoly.getGeometryN(i);
        return this.getRandomPointOnGeometry(polygon);
    }

    protected Point getRandomPointOnGeometry(MultiPoint multipoint) {
        int idx = this.uniform.nextIntFromTo(0, multipoint.getNumGeometries());
        return (Point)multipoint.getGeometryN(idx);
    }

    protected Point getRandomPointOnGeometry(MultiLineString multiline) {
        double totalLength = multiline.getLength();
        double roulette = this.uniform.nextDoubleFromTo(0.0, totalLength);
        double cumulatedLength = 0.0;
        int i = 0;
        while (i < multiline.getNumGeometries()) {
            if ((cumulatedLength += multiline.getGeometryN(i).getLength()) >= roulette) break;
            ++i;
        }
        LineString line = (LineString)multiline.getGeometryN(i);
        return this.getRandomPointOnGeometry((Geometry)line);
    }

    protected Point getRandomPointOnGeometry(Geometry geom) {
        if (geom instanceof MultiPolygon) {
            return this.getRandomPointOnGeometry((MultiPolygon)geom);
        }
        if (geom instanceof Polygon) {
            return this.getRandomPointOnGeometry((Polygon)geom);
        }
        if (geom instanceof MultiLineString) {
            return this.getRandomPointOnGeometry((MultiLineString)geom);
        }
        if (geom instanceof LineString) {
            return this.getRandomPointOnLine((LineString)geom);
        }
        if (geom instanceof MultiPoint) {
            return this.getRandomPointOnGeometry((MultiPoint)geom);
        }
        if (geom instanceof Point) {
            return this.getRandomPointOnGeometry((Point)geom);
        }
        throw new RuntimeException("unable to compute unknown geometry type " + geom);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inputTable = inData[0];
        boolean autoseed = this.m_autoseed.getBooleanValue();
        int providedSeed = this.m_seed.getIntValue();
        int count = this.m_count.getIntValue();
        DataTableSpec outputSpec = inputTable.getDataTableSpec();
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        int seed = autoseed ? (int)new Date().getTime() : providedSeed;
        this.random = new MersenneTwister(seed);
        this.uniform = new Uniform((RandomEngine)this.random);
        double total = inputTable.size() * (long)count;
        int numberOfCells = inputTable.getDataTableSpec().getNumColumns();
        int idxGeomCol = inputTable.getDataTableSpec().findColumnIndex("the_geom");
        WKTWriter writer = new WKTWriter();
        this.done = 0L;
        MissingCell missing = new MissingCell("empty geometry");
        SpatialUtils.applyToEachGeometry((BufferedDataTable)inputTable, geomAndRow -> {
            int j = 0;
            while (j < count) {
                DataCell[] cells = new DataCell[numberOfCells];
                int i = 0;
                while (i < numberOfCells) {
                    cells[i] = i == idxGeomCol ? (geomAndRow.geometry.isEmpty() ? missing : StringCell.StringCellFactory.create((String)writer.write((Geometry)this.getRandomPointOnGeometry(geomAndRow.geometry)))) : geomAndRow.row.getCell(i);
                    ++i;
                }
                RowKey key = j == 0 ? geomAndRow.row.getKey() : new RowKey(String.valueOf(geomAndRow.row.getKey().getString()) + "_" + j);
                DefaultRow row = new DefaultRow(key, cells);
                container.addRowToTable((DataRow)row);
                exec.checkCanceled();
                exec.setProgress((double)this.done / total, "creating points for row " + this.done);
                ++j;
            }
        });
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_autoseed.saveSettingsTo(settings);
        this.m_seed.saveSettingsTo(settings);
        this.m_count.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_autoseed.loadSettingsFrom(settings);
        this.m_seed.loadSettingsFrom(settings);
        this.m_count.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_autoseed.validateSettings(settings);
        this.m_seed.validateSettings(settings);
        this.m_count.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

